/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.ForbiddenAccessException;
import com.yahoo.elide.core.exceptions.InvalidObjectIdentifierException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.jsonapi.models.Resource;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ResourceIdentifier {
    private final String type;
    private final String id;

    public ResourceIdentifier(@JsonProperty(value="type") String type, @JsonProperty(value="id") String id) {
        this.type = type;
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public PersistentResource toPersistentResource(RequestScope requestScope) throws ForbiddenAccessException, InvalidObjectIdentifierException {
        Type<?> cls = requestScope.getDictionary().getEntityClass(this.type, requestScope.getApiVersion());
        return PersistentResource.loadRecord(EntityProjection.builder().type(cls).build(), this.id, requestScope);
    }

    public Resource castToResource() {
        return new Resource(this.type, this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceIdentifier that = (ResourceIdentifier)o;
        return new EqualsBuilder().append((Object)this.type, (Object)that.type).append((Object)this.id, (Object)that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.type).append((Object)this.id).toHashCode();
    }
}

