/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.jsonapi.parser.state;

import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.generated.parsers.CoreParser;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import com.yahoo.elide.jsonapi.parser.state.BaseState;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateContext {
    private static final Logger log = LoggerFactory.getLogger(StateContext.class);
    private BaseState currentState;
    private final RequestScope requestScope;

    public StateContext(BaseState initialState, RequestScope requestScope) {
        this.currentState = initialState;
        this.requestScope = requestScope;
    }

    public JsonApiDocument getJsonApiDocument() {
        return this.requestScope.getJsonApiDocument();
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    void setState(BaseState nextState) {
        log.debug("State Transition - Current State: {} New State: {}", (Object)this.currentState, (Object)nextState);
        this.currentState = nextState;
    }

    public void handle(CoreParser.RootCollectionLoadEntitiesContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.RootCollectionLoadEntityContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.RootCollectionSubCollectionContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.RootCollectionRelationshipContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.SubCollectionReadCollectionContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.SubCollectionReadEntityContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.SubCollectionSubCollectionContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public void handle(CoreParser.SubCollectionRelationshipContext ctx) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)ctx.toStringTree());
        }
        this.currentState.handle(this, ctx);
    }

    public Supplier<Pair<Integer, JsonApiDocument>> handleGet() {
        return this.currentState.handleGet(this);
    }

    public Supplier<Pair<Integer, JsonApiDocument>> handlePatch() {
        return this.currentState.handlePatch(this);
    }

    public Supplier<Pair<Integer, JsonApiDocument>> handlePost() {
        return this.currentState.handlePost(this);
    }

    public Supplier<Pair<Integer, JsonApiDocument>> handleDelete() {
        return this.currentState.handleDelete(this);
    }
}

