/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.yammer.dropwizard.Bundle;
import com.yammer.dropwizard.ConfiguredBundle;
import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.cli.ConfiguredCommand;
import com.yammer.dropwizard.cli.ServerCommand;
import com.yammer.dropwizard.cli.UsagePrinter;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.LoggingFactory;
import com.yammer.dropwizard.jersey.DropwizardResourceConfig;
import com.yammer.dropwizard.json.Json;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import javax.annotation.CheckForNull;
import javax.ws.rs.core.Application;
import org.codehaus.jackson.map.Module;

public abstract class AbstractService<T extends Configuration> {
    private final String name;
    private final List<Bundle> bundles;
    private final List<ConfiguredBundle<? super T>> configuredBundles;
    private final List<Module> modules;
    private final SortedMap<String, Command> commands;

    protected AbstractService(String name) {
        this.name = name;
        this.bundles = Lists.newArrayList();
        this.configuredBundles = Lists.newArrayList();
        this.modules = Lists.newArrayList();
        this.commands = Maps.newTreeMap();
        this.addCommand(new ServerCommand<T>(this.getConfigurationClass()));
    }

    protected abstract void subclassServiceInsteadOfThis();

    public final String getName() {
        return this.name;
    }

    public final Class<T> getConfigurationClass() {
        Type t = this.getClass();
        while (t instanceof Class) {
            t = t.getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)t).getActualTypeArguments()) {
                Class cls;
                if (!(param instanceof Class) || !Configuration.class.isAssignableFrom(cls = (Class)param)) continue;
                return cls;
            }
        }
        throw new IllegalStateException("Can not figure out Configuration type parameterization for " + this.getClass().getName());
    }

    protected final void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    protected final void addBundle(ConfiguredBundle<? super T> bundle) {
        this.configuredBundles.add(bundle);
    }

    public final ImmutableList<Command> getCommands() {
        return ImmutableList.copyOf(this.commands.values());
    }

    protected final void addCommand(Command command) {
        this.commands.put(command.getName(), command);
    }

    protected final void addCommand(ConfiguredCommand<T> command) {
        this.commands.put(command.getName(), command);
    }

    protected final void addJacksonModule(Module module) {
        this.modules.add(module);
    }

    protected abstract void initialize(T var1, Environment var2) throws Exception;

    public final void initializeWithBundles(T configuration, Environment environment) throws Exception {
        for (Bundle bundle : this.bundles) {
            bundle.initialize(environment);
        }
        for (ConfiguredBundle configuredBundle : this.configuredBundles) {
            configuredBundle.initialize(configuration, environment);
        }
        this.initialize(configuration, environment);
    }

    public final void run(String[] arguments) throws Exception {
        if (AbstractService.isHelp(arguments)) {
            UsagePrinter.printRootHelp(this);
        } else {
            Command cmd = (Command)this.commands.get(arguments[0]);
            if (cmd != null) {
                cmd.run(this, Arrays.copyOfRange(arguments, 1, arguments.length));
            } else {
                UsagePrinter.printRootHelp(this);
            }
        }
    }

    public ImmutableList<Module> getJacksonModules() {
        return ImmutableList.copyOf(this.modules);
    }

    public Json getJson() {
        Json json = new Json();
        for (Module module : this.getJacksonModules()) {
            json.registerModule(module);
        }
        return json;
    }

    @CheckForNull
    public ServletContainer getJerseyContainer(DropwizardResourceConfig resourceConfig, T serviceConfig) {
        return new ServletContainer((Application)resourceConfig);
    }

    private static boolean isHelp(String[] arguments) {
        return arguments.length == 0 || arguments.length == 1 && ("-h".equals(arguments[0]) || "--help".equals(arguments[0]));
    }

    static {
        LoggingFactory.bootstrap();
    }
}

