/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard;

import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.bundles.JavaBundle;
import com.yammer.dropwizard.config.Configuration;

public abstract class Service<T extends Configuration>
extends AbstractService<T> {
    protected Service(String name) {
        super(name);
        this.addBundle(new JavaBundle(this));
        this.checkForScalaExtensions();
    }

    @Override
    protected final void subclassServiceInsteadOfThis() {
    }

    private void checkForScalaExtensions() {
        try {
            Class<?> scalaObject = Class.forName("scala.ScalaObject");
            Class<?> klass = this.getClass();
            if (scalaObject.isAssignableFrom(klass)) {
                throw new IllegalStateException(klass.getCanonicalName() + " is a Scala class. " + "It should extend ScalaService, not Service.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

