/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.bundles;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilderSpec;
import com.yammer.dropwizard.Bundle;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.servlets.AssetServlet;
import javax.servlet.Servlet;

public class AssetsBundle
implements Bundle {
    public static final String DEFAULT_PATH = "/assets";
    public static final CacheBuilderSpec DEFAULT_CACHE_SPEC = CacheBuilderSpec.parse((String)"maximumSize=100");
    private final String resourcePath;
    private final String uriPath;
    private final CacheBuilderSpec cacheBuilderSpec;

    public AssetsBundle() {
        this(DEFAULT_PATH, DEFAULT_CACHE_SPEC);
    }

    public AssetsBundle(String path) {
        this(path, DEFAULT_CACHE_SPEC, path);
    }

    public AssetsBundle(String resourcePath, String uriPath) {
        this(resourcePath, DEFAULT_CACHE_SPEC, uriPath);
    }

    public AssetsBundle(String resourcePath, CacheBuilderSpec cacheBuilderSpec) {
        this(resourcePath, cacheBuilderSpec, resourcePath);
    }

    public AssetsBundle(String resourcePath, CacheBuilderSpec cacheBuilderSpec, String uriPath) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"%s is not an absolute path", (Object[])new Object[]{resourcePath});
        Preconditions.checkArgument((!"/".equals(resourcePath) ? 1 : 0) != 0, (String)"%s is the classpath root", (Object[])new Object[]{resourcePath});
        this.resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + '/';
        this.uriPath = uriPath.endsWith("/") ? uriPath : uriPath + '/';
        this.cacheBuilderSpec = cacheBuilderSpec;
    }

    @Override
    public void initialize(Environment environment) {
        environment.addServlet((Servlet)new AssetServlet(this.resourcePath, this.cacheBuilderSpec, this.uriPath), this.uriPath + '*');
    }
}

