/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.ConfigurationFactory;
import com.yammer.dropwizard.config.LoggingFactory;
import com.yammer.dropwizard.validation.Validator;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.cli.CommandLine;

public abstract class ConfiguredCommand<T extends Configuration>
extends Command {
    protected ConfiguredCommand(String name, String description) {
        super(name, description);
    }

    protected Class<T> getConfigurationClass() {
        Type t = this.getClass();
        while (t instanceof Class) {
            t = t.getGenericSuperclass();
        }
        if (t instanceof ParameterizedType) {
            for (Type param : ((ParameterizedType)t).getActualTypeArguments()) {
                Class cls;
                if (!(param instanceof Class) || !Configuration.class.isAssignableFrom(cls = (Class)param)) continue;
                return cls;
            }
        }
        throw new IllegalStateException("Can not figure out Configuration type parameterization for " + this.getClass().getName());
    }

    protected String getConfiguredSyntax() {
        return null;
    }

    @Override
    protected final String getSyntax() {
        StringBuilder syntax = new StringBuilder("<config file>");
        String configured = this.getConfiguredSyntax();
        if (configured != null && !configured.isEmpty()) {
            syntax.append(' ').append(configured);
        }
        return syntax.toString();
    }

    @Override
    protected final void run(AbstractService<?> service, CommandLine params) throws Exception {
        ConfigurationFactory<T> factory = ConfigurationFactory.forClass(this.getConfigurationClass(), new Validator(), service.getJacksonModules());
        String[] args = params.getArgs();
        if (args.length >= 1) {
            params.getArgList().remove(0);
            try {
                Configuration configuration = (Configuration)factory.build(new File(args[0]));
                new LoggingFactory(configuration.getLoggingConfiguration(), service.getName()).configure();
                this.run(service, configuration, params);
            }
            catch (ConfigurationException e) {
                this.printHelp(e.getMessage(), service.getClass());
            }
        } else {
            this.printHelp(service.getClass());
            System.exit(-1);
        }
    }

    protected abstract void run(AbstractService<T> var1, T var2, CommandLine var3) throws Exception;
}

