/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.yammer.dropwizard.AbstractService;
import com.yammer.dropwizard.cli.ConfiguredCommand;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.ServerFactory;
import com.yammer.dropwizard.logging.Log;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.cli.CommandLine;
import org.eclipse.jetty.server.Server;

public class ServerCommand<T extends Configuration>
extends ConfiguredCommand<T> {
    private final Class<T> configurationClass;

    public ServerCommand(Class<T> configurationClass) {
        super("server", "Starts an HTTP server running the service");
        this.configurationClass = configurationClass;
    }

    @Override
    protected Class<T> getConfigurationClass() {
        return this.configurationClass;
    }

    @Override
    protected void run(AbstractService<T> service, T configuration, CommandLine params) throws Exception {
        Environment environment = new Environment(service, configuration);
        service.initializeWithBundles(configuration, environment);
        Server server = new ServerFactory(((Configuration)configuration).getHttpConfiguration(), service.getName()).buildServer(environment);
        Log log = Log.forClass(ServerCommand.class);
        this.logBanner(service, log);
        try {
            server.start();
            server.join();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Unable to start server, shutting down", new Object[0]);
            server.stop();
        }
    }

    private void logBanner(AbstractService<T> service, Log log) {
        try {
            String banner = Resources.toString((URL)Resources.getResource((String)"banner.txt"), (Charset)Charsets.UTF_8);
            log.info("Starting {}\n{}", (Object)service.getName(), (Object)banner);
        }
        catch (IllegalArgumentException ignored) {
            log.info("Starting {}", (Object)service.getName());
        }
        catch (IOException ignored) {
            log.info("Starting {}", (Object)service.getName());
        }
    }
}

