/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import java.util.Map;
import org.eclipse.jetty.servlet.FilterHolder;

public class FilterConfiguration {
    private final FilterHolder holder;
    private final ImmutableMultimap.Builder<String, FilterHolder> mappings;

    public FilterConfiguration(FilterHolder holder, ImmutableMultimap.Builder<String, FilterHolder> mappings) {
        this.holder = holder;
        this.mappings = mappings;
    }

    public FilterConfiguration setName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name must be non-empty");
        this.holder.setName(name);
        return this;
    }

    public FilterConfiguration setInitParam(String name, String value) {
        this.holder.setInitParameter((String)Preconditions.checkNotNull((Object)name), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public FilterConfiguration addInitParams(Map<String, String> params) {
        for (Map.Entry entry : ((Map)Preconditions.checkNotNull(params)).entrySet()) {
            this.setInitParam((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public FilterConfiguration addUrlPattern(String urlPattern) {
        this.mappings.put(Preconditions.checkNotNull((Object)urlPattern), (Object)this.holder);
        return this;
    }

    public FilterConfiguration addUrlPatterns(String urlPattern, String ... urlPatterns) {
        this.addUrlPattern((String)Preconditions.checkNotNull((Object)urlPattern));
        for (String pattern : (String[])Preconditions.checkNotNull((Object)urlPatterns)) {
            this.addUrlPattern((String)Preconditions.checkNotNull((Object)pattern));
        }
        return this;
    }
}

