/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.config.GzipConfiguration;
import com.yammer.dropwizard.config.RequestLogConfiguration;
import com.yammer.dropwizard.config.SslConfiguration;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.util.Size;
import com.yammer.dropwizard.validation.ValidationMethod;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.codehaus.jackson.annotate.JsonProperty;

public class HttpConfiguration {
    @Valid
    @NotNull
    @JsonProperty
    protected RequestLogConfiguration requestLog = new RequestLogConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    protected GzipConfiguration gzip = new GzipConfiguration();
    @Valid
    @JsonProperty
    protected SslConfiguration ssl = null;
    @NotNull
    @JsonProperty
    protected ImmutableMap<String, String> contextParameters = ImmutableMap.of();
    @Min(value=1025L)
    @Max(value=65535L)
    @JsonProperty
    protected int port = 8080;
    @Min(value=1025L)
    @Max(value=65535L)
    @JsonProperty
    protected int adminPort = 8081;
    @Min(value=2L)
    @Max(value=1000000L)
    @JsonProperty
    protected int maxThreads = 254;
    @Min(value=1L)
    @Max(value=1000000L)
    @JsonProperty
    protected int minThreads = 8;
    @NotNull
    @JsonProperty
    protected String rootPath = "/*";
    @NotNull
    @Pattern(regexp="^(blocking|nonblocking|nonblocking\\+ssl|legacy|legacy\\+ssl)$", flags={Pattern.Flag.CASE_INSENSITIVE})
    @JsonProperty
    protected String connectorType = "blocking";
    @NotNull
    @JsonProperty
    protected Duration maxIdleTime = Duration.seconds(200L);
    @Min(value=1L)
    @Max(value=128L)
    @JsonProperty
    protected int acceptorThreadCount = 1;
    @Min(value=-5L)
    @Max(value=5L)
    @JsonProperty
    protected int acceptorThreadPriorityOffset = 0;
    @Min(value=-1L)
    @JsonProperty
    protected int acceptQueueSize = -1;
    @Min(value=1L)
    @JsonProperty
    protected int maxBufferCount = 1024;
    @NotNull
    @JsonProperty
    protected Size requestBufferSize = Size.kilobytes(16L);
    @NotNull
    @JsonProperty
    protected Size requestHeaderBufferSize = Size.kilobytes(6L);
    @NotNull
    @JsonProperty
    protected Size responseBufferSize = Size.kilobytes(32L);
    @NotNull
    @JsonProperty
    protected Size responseHeaderBufferSize = Size.kilobytes(6L);
    @JsonProperty
    protected boolean reuseAddress = true;
    @JsonProperty
    protected Duration soLingerTime = null;
    @JsonProperty
    protected int lowResourcesConnectionThreshold = 0;
    @NotNull
    @JsonProperty
    protected Duration lowResourcesMaxIdleTime = Duration.seconds(0L);
    @NotNull
    @JsonProperty
    protected Duration shutdownGracePeriod = Duration.seconds(2L);
    @JsonProperty
    protected boolean useServerHeader = false;
    @JsonProperty
    protected boolean useDateHeader = true;
    @JsonProperty
    protected boolean useForwardedHeaders = true;
    @JsonProperty
    protected boolean useDirectBuffers = true;
    @JsonProperty
    protected String bindHost = null;
    @JsonProperty
    protected String adminUsername = null;
    @JsonProperty
    protected String adminPassword = null;

    @ValidationMethod(message="must have an SSL configuration when using SSL connection")
    public boolean isSslConfigured() {
        ConnectorType type = this.getConnectorType();
        return this.ssl != null || type != ConnectorType.SOCKET_SSL && type != ConnectorType.SELECT_CHANNEL_SSL;
    }

    @ValidationMethod(message="must have a smaller minThreads than maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @ValidationMethod(message="must have adminUsername if adminPassword is defined")
    public boolean isAdminUsernameDefined() {
        return this.adminPassword == null || this.adminUsername != null;
    }

    public RequestLogConfiguration getRequestLogConfiguration() {
        return this.requestLog;
    }

    public GzipConfiguration getGzipConfiguration() {
        return this.gzip;
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public ImmutableMap<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public ConnectorType getConnectorType() {
        if ("blocking".equalsIgnoreCase(this.connectorType)) {
            return ConnectorType.BLOCKING_CHANNEL;
        }
        if ("legacy".equalsIgnoreCase(this.connectorType)) {
            return ConnectorType.SOCKET;
        }
        if ("legacy+ssl".equalsIgnoreCase(this.connectorType)) {
            return ConnectorType.SOCKET_SSL;
        }
        if ("nonblocking".equalsIgnoreCase(this.connectorType)) {
            return ConnectorType.SELECT_CHANNEL;
        }
        if ("nonblocking+ssl".equalsIgnoreCase(this.connectorType)) {
            return ConnectorType.SELECT_CHANNEL_SSL;
        }
        throw new IllegalStateException("Invalid connector type: " + this.connectorType);
    }

    public int getPort() {
        return this.port;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public int getAcceptorThreadCount() {
        return this.acceptorThreadCount;
    }

    public int getAcceptorThreadPriorityOffset() {
        return this.acceptorThreadPriorityOffset;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public int getMaxBufferCount() {
        return this.maxBufferCount;
    }

    public Size getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public Size getRequestHeaderBufferSize() {
        return this.requestHeaderBufferSize;
    }

    public Size getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public Size getResponseHeaderBufferSize() {
        return this.responseHeaderBufferSize;
    }

    public boolean isReuseAddressEnabled() {
        return this.reuseAddress;
    }

    public Optional<Duration> getSoLingerTime() {
        return Optional.fromNullable((Object)this.soLingerTime);
    }

    public int getLowResourcesConnectionThreshold() {
        return this.lowResourcesConnectionThreshold;
    }

    public Duration getLowResourcesMaxIdleTime() {
        return this.lowResourcesMaxIdleTime;
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public boolean useForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    public boolean useDirectBuffers() {
        return this.useDirectBuffers;
    }

    public Optional<String> getBindHost() {
        return Optional.fromNullable((Object)this.bindHost);
    }

    public boolean isDateHeaderEnabled() {
        return this.useDateHeader;
    }

    public boolean isServerHeaderEnabled() {
        return this.useServerHeader;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Optional<String> getAdminUsername() {
        return Optional.fromNullable((Object)this.adminUsername);
    }

    public Optional<String> getAdminPassword() {
        return Optional.fromNullable((Object)this.adminPassword);
    }

    public static enum ConnectorType {
        SOCKET,
        BLOCKING_CHANNEL,
        SELECT_CHANNEL,
        SOCKET_SSL,
        SELECT_CHANNEL_SSL;

    }
}

