/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey;

import com.google.common.collect.ImmutableList;
import com.yammer.dropwizard.json.Json;
import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.validation.InvalidEntityException;
import com.yammer.dropwizard.validation.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.eclipse.jetty.io.EofException;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JacksonMessageBodyProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Log LOG = Log.forClass(JacksonMessageBodyProvider.class);
    private static final Validator VALIDATOR = new Validator();
    private final Json json;

    public JacksonMessageBodyProvider(Json json) {
        this.json = json;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.json.canDeserialize(type);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ImmutableList<String> errors;
        boolean validating = false;
        for (Annotation annotation : annotations) {
            validating = validating || annotation.annotationType() == Valid.class;
        }
        Object value = this.parseEntity(genericType, entityStream);
        if (validating && !(errors = VALIDATOR.validate(value)).isEmpty()) {
            throw new InvalidEntityException("The request entity had the following errors:", (Iterable<String>)errors);
        }
        return value;
    }

    private Object parseEntity(Type genericType, InputStream entityStream) throws IOException {
        return this.json.readValue(entityStream, genericType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.json.canSerialize(type);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            this.json.writeValue(entityStream, t);
        }
        catch (EofException ignored) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e, "Error writing response", new Object[0]);
        }
    }
}

