/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jersey.caching;

import com.sun.jersey.api.model.AbstractResourceMethod;
import com.sun.jersey.spi.container.ResourceMethodDispatchProvider;
import com.sun.jersey.spi.dispatch.RequestDispatcher;
import com.yammer.dropwizard.jersey.caching.CacheControl;
import com.yammer.dropwizard.jersey.caching.CacheControlledRequestDispatcher;
import java.util.concurrent.TimeUnit;

public class CacheControlledResourceMethodDispatchProvider
implements ResourceMethodDispatchProvider {
    private static final int ONE_YEAR_IN_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L);
    private final ResourceMethodDispatchProvider provider;

    public CacheControlledResourceMethodDispatchProvider(ResourceMethodDispatchProvider provider) {
        this.provider = provider;
    }

    public RequestDispatcher create(AbstractResourceMethod abstractResourceMethod) {
        RequestDispatcher dispatcher = this.provider.create(abstractResourceMethod);
        CacheControl control = (CacheControl)abstractResourceMethod.getAnnotation(CacheControl.class);
        if (control != null) {
            javax.ws.rs.core.CacheControl cacheControl = new javax.ws.rs.core.CacheControl();
            cacheControl.setPrivate(control.isPrivate());
            cacheControl.setNoCache(control.noCache());
            cacheControl.setNoStore(control.noStore());
            cacheControl.setNoTransform(control.noTransform());
            cacheControl.setMustRevalidate(control.mustRevalidate());
            cacheControl.setProxyRevalidate(control.proxyRevalidate());
            cacheControl.setMaxAge((int)control.maxAgeUnit().toSeconds(control.maxAge()));
            cacheControl.setSMaxAge((int)control.sharedMaxAgeUnit().toSeconds(control.sharedMaxAge()));
            if (control.immutable()) {
                cacheControl.setMaxAge(ONE_YEAR_IN_SECONDS);
            }
            return new CacheControlledRequestDispatcher(dispatcher, cacheControl);
        }
        return dispatcher;
    }
}

