/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.jetty;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class InstrumentedSslSelectChannelConnector
extends SslSelectChannelConnector {
    private final Timer duration;
    private final Meter accepts;
    private final Meter connects;
    private final Meter disconnects;
    private final Counter connections;

    public InstrumentedSslSelectChannelConnector(int port) {
        this(Metrics.defaultRegistry(), port);
    }

    public InstrumentedSslSelectChannelConnector(MetricsRegistry registry, int port) {
        this.setPort(port);
        this.duration = registry.newTimer(SelectChannelConnector.class, "connection-duration", Integer.toString(port), TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.accepts = registry.newMeter(SelectChannelConnector.class, "accepts", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connects = registry.newMeter(SelectChannelConnector.class, "connects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.disconnects = registry.newMeter(SelectChannelConnector.class, "disconnects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connections = registry.newCounter(SelectChannelConnector.class, "active-connections", Integer.toString(port));
    }

    public InstrumentedSslSelectChannelConnector(SslContextFactory contextFactory, int port) {
        this(contextFactory, Metrics.defaultRegistry(), port);
    }

    public InstrumentedSslSelectChannelConnector(SslContextFactory contextFactory, MetricsRegistry registry, int port) {
        super(contextFactory);
        this.setPort(port);
        this.duration = registry.newTimer(SocketConnector.class, "connection-duration", Integer.toString(port), TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
        this.accepts = registry.newMeter(SocketConnector.class, "accepts", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connects = registry.newMeter(SocketConnector.class, "connects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.disconnects = registry.newMeter(SocketConnector.class, "disconnects", Integer.toString(port), "connections", TimeUnit.SECONDS);
        this.connections = registry.newCounter(SocketConnector.class, "active-connections", Integer.toString(port));
    }

    public void accept(int acceptorID) throws IOException {
        super.accept(acceptorID);
        this.accepts.mark();
    }

    protected void connectionOpened(Connection connection) {
        this.connections.inc();
        super.connectionOpened(connection);
        this.connects.mark();
    }

    protected void connectionClosed(Connection connection) {
        super.connectionClosed(connection);
        this.disconnects.mark();
        long duration = System.currentTimeMillis() - connection.getTimeStamp();
        this.duration.update(duration, TimeUnit.MILLISECONDS);
        this.connections.dec();
    }
}

