/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.json;

import com.google.common.cache.CacheBuilderSpec;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.type.JavaType;

public class GuavaExtrasModule
extends Module {
    public String getModuleName() {
        return "guava-extras";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new GuavaExtrasDeserializers());
    }

    private static class GuavaExtrasDeserializers
    extends Deserializers.Base {
        private GuavaExtrasDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecDeserializer();
            }
            if (HostAndPort.class.isAssignableFrom(type.getRawClass())) {
                return new HostAndPortDeserializer();
            }
            return super.findBeanDeserializer(type, config, provider, beanDesc, property);
        }
    }

    @JsonCachable
    private static class CacheBuilderSpecDeserializer
    extends JsonDeserializer<CacheBuilderSpec> {
        private CacheBuilderSpecDeserializer() {
        }

        public CacheBuilderSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if ("off".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text)) {
                return CacheBuilderSpec.disableCaching();
            }
            return CacheBuilderSpec.parse((String)text);
        }
    }

    @JsonCachable
    private static class HostAndPortDeserializer
    extends JsonDeserializer<HostAndPort> {
        private HostAndPortDeserializer() {
        }

        public HostAndPort deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return HostAndPort.fromString((String)jp.getText());
        }
    }
}

