/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.json;

import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.yammer.dropwizard.json.AnnotationSensitivePropertyNamingStrategy;
import com.yammer.dropwizard.json.GuavaExtrasModule;
import com.yammer.dropwizard.json.LogbackModule;
import com.yammer.dropwizard.json.YamlConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.type.TypeReference;

public class Json {
    protected JsonFactory factory = new MappingJsonFactory();
    protected ObjectMapper mapper;
    protected TypeFactory typeFactory;

    public Json() {
        this.factory.enable(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT);
        this.factory.enable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        this.factory.enable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        this.factory.enable(JsonParser.Feature.ALLOW_COMMENTS);
        this.factory.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        this.mapper = (ObjectMapper)this.factory.getCodec();
        this.mapper.setPropertyNamingStrategy((PropertyNamingStrategy)AnnotationSensitivePropertyNamingStrategy.INSTANCE);
        this.mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES});
        this.mapper.disable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING});
        this.mapper.disable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING});
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new LogbackModule());
        this.mapper.registerModule((Module)new GuavaExtrasModule());
        this.typeFactory = this.mapper.getTypeFactory();
    }

    public void registerModule(Module module) {
        this.mapper.registerModule(module);
    }

    public boolean isEnabled(DeserializationConfig.Feature feature) {
        return this.mapper.isEnabled(feature);
    }

    public void enable(DeserializationConfig.Feature ... features) {
        this.mapper.enable(features);
    }

    public void disable(DeserializationConfig.Feature ... features) {
        this.mapper.disable(features);
    }

    public boolean isEnabled(SerializationConfig.Feature feature) {
        return this.mapper.isEnabled(feature);
    }

    public void enable(SerializationConfig.Feature ... features) {
        this.mapper.enable(features);
    }

    public void disable(SerializationConfig.Feature ... features) {
        this.mapper.disable(features);
    }

    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this.mapper.isEnabled(feature);
    }

    public void enable(JsonGenerator.Feature ... features) {
        for (JsonGenerator.Feature feature : features) {
            this.factory.enable(feature);
        }
    }

    public void disable(JsonGenerator.Feature ... features) {
        for (JsonGenerator.Feature feature : features) {
            this.factory.disable(feature);
        }
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this.mapper.isEnabled(feature);
    }

    public void enable(JsonParser.Feature ... features) {
        for (JsonParser.Feature feature : features) {
            this.factory.enable(feature);
        }
    }

    public void disable(JsonParser.Feature ... features) {
        for (JsonParser.Feature feature : features) {
            this.factory.disable(feature);
        }
    }

    public boolean canSerialize(Class<?> type) {
        return this.mapper.canSerialize(type);
    }

    public boolean canDeserialize(Class<?> type) {
        return this.mapper.canDeserialize(this.constructType(type));
    }

    public <T> T readValue(File src, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(src, valueType);
    }

    public <T> T readValue(File src, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(src, valueTypeRef);
    }

    public <T> T readValue(String content, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(content, valueType);
    }

    public <T> T readValue(String content, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(content, valueTypeRef);
    }

    public <T> T readValue(Reader src, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(src, valueType);
    }

    public <T> T readValue(Reader src, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(src, valueTypeRef);
    }

    public <T> T readValue(InputStream src, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(src, valueType);
    }

    public <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(src, valueTypeRef);
    }

    public <T> T readValue(InputStream src, Type valueType) throws IOException {
        return (T)this.mapper.readValue(src, this.constructType(valueType));
    }

    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(src, valueType);
    }

    public <T> T readValue(byte[] src, int offset, int len, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(src, offset, len, valueType);
    }

    public <T> T readValue(byte[] src, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(src, valueTypeRef);
    }

    public <T> T readValue(byte[] src, int offset, int len, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(src, offset, len, valueTypeRef);
    }

    public <T> T readValue(JsonNode root, Class<T> valueType) throws IOException {
        return (T)this.mapper.readValue(root, valueType);
    }

    public <T> T readValue(JsonNode root, TypeReference<T> valueTypeRef) throws IOException {
        return (T)this.mapper.readValue(root, valueTypeRef);
    }

    public void writeValue(File output, Object value) throws IOException {
        this.mapper.writeValue(output, value);
    }

    public void writeValue(OutputStream output, Object value) throws IOException {
        this.mapper.writeValue(output, value);
    }

    public void writeValue(Writer output, Object value) throws IOException {
        this.mapper.writeValue(output, value);
    }

    public String writeValueAsString(Object value) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) throws IllegalArgumentException {
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public JsonNode writeValueAsTree(Object value) throws IllegalArgumentException {
        return this.mapper.valueToTree(value);
    }

    public <T> T readYamlValue(File src, Class<T> valueType) throws IOException {
        YamlConverter converter = new YamlConverter(this, this.factory);
        return (T)this.mapper.readValue(converter.convert(src), valueType);
    }

    public <T> T readYamlValue(File src, TypeReference<T> valueTypeRef) throws IOException {
        YamlConverter converter = new YamlConverter(this, this.factory);
        return (T)this.mapper.readValue(converter.convert(src), valueTypeRef);
    }

    private JavaType constructType(Type type) {
        return this.typeFactory.constructType(type);
    }
}

