/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.json;

import ch.qos.logback.classic.Level;
import java.io.IOException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.annotate.JsonCachable;
import org.codehaus.jackson.type.JavaType;

class LogbackModule
extends Module {
    LogbackModule() {
    }

    public String getModuleName() {
        return "LogbackModule";
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public void setupModule(Module.SetupContext context) {
        context.addDeserializers((Deserializers)new LogbackDeserializers());
    }

    private static class LogbackDeserializers
    extends Deserializers.Base {
        private LogbackDeserializers() {
        }

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property) throws JsonMappingException {
            if (Level.class.isAssignableFrom(type.getRawClass())) {
                return new LevelDeserializer();
            }
            return super.findBeanDeserializer(type, config, provider, beanDesc, property);
        }
    }

    @JsonCachable
    private static class LevelDeserializer
    extends JsonDeserializer<Level> {
        private LevelDeserializer() {
        }

        public Level deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            if ("false".equalsIgnoreCase(text)) {
                return Level.OFF;
            }
            if ("true".equalsIgnoreCase(text)) {
                return Level.ALL;
            }
            return Level.toLevel((String)text, (Level)Level.INFO);
        }
    }
}

