/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.json;

import com.google.common.base.Charsets;
import com.yammer.dropwizard.json.Json;
import com.yammer.dropwizard.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

class YamlConverter {
    private static final Log LOG = Log.forClass(YamlConverter.class);
    private final Json json;
    private final JsonFactory factory;

    YamlConverter(Json json, JsonFactory factory) {
        this.factory = factory;
        this.json = json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonNode convert(File file) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        JsonGenerator generator = this.factory.createJsonGenerator((OutputStream)output).useDefaultPrettyPrinter();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
        try {
            Node yaml = new Yaml().compose((Reader)reader);
            this.build(yaml, generator);
            generator.close();
            LOG.debug("Parsed {} as:\n {}", (Object)file, (Object)output.toString());
            JsonNode jsonNode = this.json.readValue(output.toByteArray(), JsonNode.class);
            return jsonNode;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private void build(Node yaml, JsonGenerator json) throws IOException {
        if (yaml instanceof MappingNode) {
            MappingNode mappingNode = (MappingNode)yaml;
            json.writeStartObject();
            for (NodeTuple tuple : mappingNode.getValue()) {
                if (tuple.getKeyNode() instanceof ScalarNode) {
                    json.writeFieldName(((ScalarNode)tuple.getKeyNode()).getValue());
                }
                this.build(tuple.getValueNode(), json);
            }
            json.writeEndObject();
        } else if (yaml instanceof SequenceNode) {
            json.writeStartArray();
            for (Node node : ((SequenceNode)yaml).getValue()) {
                this.build(node, json);
            }
            json.writeEndArray();
        } else if (yaml instanceof ScalarNode) {
            ScalarNode scalarNode = (ScalarNode)yaml;
            String className = scalarNode.getTag().getClassName();
            if ("bool".equals(className)) {
                json.writeBoolean(Boolean.parseBoolean(scalarNode.getValue()));
            } else if ("int".equals(className)) {
                json.writeNumber(Long.parseLong(scalarNode.getValue()));
            } else if ("float".equals(className)) {
                json.writeNumber(Double.parseDouble(scalarNode.getValue()));
            } else if ("null".equals(className)) {
                json.writeNull();
            } else {
                json.writeString(scalarNode.getValue());
            }
        }
    }
}

