/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.logging;

import ch.qos.logback.classic.Level;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class Log {
    private final ch.qos.logback.classic.Logger logger;

    public static Log forClass(Class<?> klass) {
        return Log.forSlf4jLogger(LoggerFactory.getLogger(klass));
    }

    public static Log named(String name) {
        return Log.forSlf4jLogger(LoggerFactory.getLogger((String)name));
    }

    public static Log forLog4jLogger(org.apache.log4j.Logger logger) {
        return Log.named(logger.getName());
    }

    public static Log forSlf4jLogger(Logger logger) {
        return new Log((ch.qos.logback.classic.Logger)logger);
    }

    public static Log forJulLogger(java.util.logging.Logger logger) {
        return Log.named(logger.getName());
    }

    private Log(ch.qos.logback.classic.Logger logger) {
        this.logger = logger;
    }

    public void setLevel(Level level) {
        this.logger.setLevel(level);
    }

    @Deprecated
    public void setLevel(org.apache.log4j.Level level) {
        String s = level.toString().toUpperCase(Locale.US);
        if ("FATAL".equals(s)) {
            this.logger.setLevel(Level.ERROR);
        }
        this.logger.setLevel(Level.toLevel((String)s));
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String message) {
        this.logger.trace(message);
    }

    public void trace(String message, Object arg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.format((String)message, (Object)arg).getMessage());
        }
    }

    public void trace(String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void trace(String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        }
    }

    public void trace(Throwable e, String message, Object arg) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
        }
    }

    public void trace(Throwable e, String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
        }
    }

    public void trace(Throwable e, String message, Object ... args) {
        if (this.isTraceEnabled()) {
            this.logger.trace(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String message) {
        this.logger.debug(message);
    }

    public void debug(String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format((String)message, (Object)arg).getMessage());
        }
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        }
    }

    public void debug(Throwable e, String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
        }
    }

    public void debug(Throwable e, String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
        }
    }

    public void debug(Throwable e, String message, Object ... args) {
        if (this.isDebugEnabled()) {
            this.logger.debug(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, Object arg) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format((String)message, (Object)arg).getMessage());
        }
    }

    public void info(String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
        }
    }

    public void info(Throwable e, String message, Object arg) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
        }
    }

    public void info(Throwable e, String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
        }
    }

    public void info(Throwable e, String message, Object ... args) {
        if (this.isInfoEnabled()) {
            this.logger.info(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
        }
    }

    public void warn(String message) {
        this.logger.warn(message);
    }

    public void warn(String message, Object arg) {
        this.logger.warn(MessageFormatter.format((String)message, (Object)arg).getMessage());
    }

    public void warn(String message, Object arg1, Object arg2) {
        this.logger.warn(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
    }

    public void warn(String message, Object ... args) {
        this.logger.warn(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
    }

    public void warn(Throwable e, String message, Object arg) {
        this.logger.warn(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
    }

    public void warn(Throwable e, String message, Object arg1, Object arg2) {
        this.logger.warn(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
    }

    public void warn(Throwable e, String message, Object ... args) {
        this.logger.warn(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
    }

    public void error(String message) {
        this.logger.error(message);
    }

    public void error(String message, Object arg) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg).getMessage());
    }

    public void error(String message, Object arg1, Object arg2) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
    }

    public void error(String message, Object ... args) {
        this.logger.error(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
    }

    public void error(Throwable e, String message, Object arg) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
    }

    public void error(Throwable e, String message, Object arg1, Object arg2) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
    }

    public void error(Throwable e, String message, Object ... args) {
        this.logger.error(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
    }

    @Deprecated
    public void fatal(String message) {
        this.logger.error(message);
    }

    @Deprecated
    public void fatal(String message, Object arg) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg).getMessage());
    }

    @Deprecated
    public void fatal(String message, Object arg1, Object arg2) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
    }

    @Deprecated
    public void fatal(String message, Object ... args) {
        this.logger.error(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage());
    }

    @Deprecated
    public void fatal(Throwable e, String message, Object arg) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg).getMessage(), e);
    }

    @Deprecated
    public void fatal(Throwable e, String message, Object arg1, Object arg2) {
        this.logger.error(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage(), e);
    }

    @Deprecated
    public void fatal(Throwable e, String message, Object ... args) {
        this.logger.error(MessageFormatter.arrayFormat((String)message, (Object[])args).getMessage(), e);
    }

    public Level getLevel() {
        return this.logger.getEffectiveLevel();
    }
}

