/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.collect.Lists;
import com.yammer.dropwizard.logging.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.LogManager;
import java.util.logging.LoggingMXBean;
import org.slf4j.LoggerFactory;

public class LoggingBean
implements LoggingMXBean {
    @Override
    public String getLoggerLevel(String loggerName) {
        return Log.named(loggerName).getLevel().toString();
    }

    @Override
    public List<String> getLoggerNames() {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList names = Lists.newArrayList();
        for (Logger logger : root.getLoggerContext().getLoggerList()) {
            names.add(logger.getName());
        }
        Enumeration<String> moreNames = LogManager.getLogManager().getLoggerNames();
        while (moreNames.hasMoreElements()) {
            String name = moreNames.nextElement();
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelName) {
        Level newLevel = Level.toLevel((String)levelName, (Level)Level.INFO);
        Log.named(loggerName).setLevel(newLevel);
    }

    @Override
    public String getParentLoggerName(String loggerName) {
        throw new UnsupportedOperationException("Can't determine parents.");
    }
}

