/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.yammer.dropwizard.logging.Log;
import com.yammer.dropwizard.tasks.Task;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TaskServlet
extends HttpServlet {
    private static final long serialVersionUID = 7404713218661358124L;
    private static final Log LOG = Log.forClass(TaskServlet.class);
    private final ImmutableMap<String, Task> tasks;

    public TaskServlet(Iterable<Task> tasks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Task task : tasks) {
            builder.put((Object)("/tasks/" + task.getName()), (Object)task);
        }
        this.tasks = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Task task = (Task)this.tasks.get((Object)req.getRequestURI());
        if (task != null) {
            try {
                resp.setContentType("text/plain");
                PrintWriter output = resp.getWriter();
                try {
                    task.execute(TaskServlet.getParams(req), output);
                }
                finally {
                    output.close();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e, "Error running {}", (Object)task.getName());
                resp.sendError(500);
            }
        } else {
            resp.sendError(404);
        }
    }

    private static ImmutableMultimap<String, String> getParams(HttpServletRequest req) {
        ImmutableMultimap.Builder results = ImmutableMultimap.builder();
        Enumeration names = req.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object[] values = req.getParameterValues(name);
            results.putAll((Object)name, values);
        }
        return results.build();
    }
}

