/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.google.common.collect.Maps;
import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.util.JarLocation;
import java.util.SortedMap;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.action.VersionArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class Cli {
    private static final String COMMAND_NAME_ATTR = "command";
    private static final String[] HELP = new String[]{"-h"};
    private final SortedMap<String, Command> commands = Maps.newTreeMap();
    private final Bootstrap<?> bootstrap;
    private final ArgumentParser parser;

    public Cli(Class<?> serviceClass, Bootstrap<?> bootstrap) {
        this.parser = this.buildParser(serviceClass);
        this.bootstrap = bootstrap;
        for (Command command : bootstrap.getCommands()) {
            this.addCommand(command);
        }
    }

    public void run(String[] arguments) throws Exception {
        try {
            String[] args = arguments.length == 0 ? HELP : arguments;
            Namespace namespace = this.parser.parseArgs(args);
            Command command = (Command)this.commands.get(namespace.getString(COMMAND_NAME_ATTR));
            command.run(this.bootstrap, namespace);
        }
        catch (ArgumentParserException e) {
            this.parser.handleError(e);
            System.exit(1);
        }
    }

    private ArgumentParser buildParser(Class<?> serviceClass) {
        String usage = "java -jar " + new JarLocation(serviceClass);
        ArgumentParser p = ArgumentParsers.newArgumentParser((String)usage).defaultHelp(true);
        Package pkg = serviceClass.getPackage();
        String version = pkg != null ? pkg.getImplementationVersion() : "No service version detected. Add a Implementation-Version entry to your JAR's manifest to enable this.";
        p.version(version);
        p.addArgument(new String[]{"-v", "--version"}).action((ArgumentAction)new VersionArgumentAction()).help("show the service version and exit");
        return p;
    }

    private void addCommand(Command command) {
        this.commands.put(command.getName(), command);
        this.parser.addSubparsers().help("available commands");
        Subparser subparser = this.parser.addSubparsers().addParser(command.getName());
        command.configure(subparser);
        subparser.description(command.getDescription()).setDefault(COMMAND_NAME_ATTR, (Object)command.getName()).defaultHelp(true);
    }
}

