/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.cli;

import com.yammer.dropwizard.cli.Command;
import com.yammer.dropwizard.config.Bootstrap;
import com.yammer.dropwizard.config.Configuration;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.ConfigurationFactory;
import com.yammer.dropwizard.config.LoggingFactory;
import com.yammer.dropwizard.json.ObjectMapperFactory;
import com.yammer.dropwizard.util.Generics;
import com.yammer.dropwizard.validation.Validator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public abstract class ConfiguredCommand<T extends Configuration>
extends Command {
    protected ConfiguredCommand(String name, String description) {
        super(name, description);
    }

    protected Class<T> getConfigurationClass() {
        return Generics.getTypeParameter(this.getClass(), Configuration.class);
    }

    @Override
    public void configure(Subparser subparser) {
        subparser.addArgument(new String[]{"file"}).nargs("?").help("service configuration file");
    }

    @Override
    public final void run(Bootstrap<?> bootstrap, Namespace namespace) throws Exception {
        T configuration = this.parseConfiguration(namespace.getString("file"), this.getConfigurationClass(), bootstrap.getObjectMapperFactory().copy());
        if (configuration != null) {
            new LoggingFactory(((Configuration)configuration).getLoggingConfiguration(), bootstrap.getName()).configure();
        }
        this.run(bootstrap, namespace, configuration);
    }

    protected abstract void run(Bootstrap<T> var1, Namespace var2, T var3) throws Exception;

    private T parseConfiguration(String filename, Class<T> configurationClass, ObjectMapperFactory objectMapperFactory) throws IOException, ConfigurationException {
        ConfigurationFactory<T> configurationFactory = ConfigurationFactory.forClass(configurationClass, new Validator(), objectMapperFactory);
        if (filename != null) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new FileNotFoundException("File " + file + " not found");
            }
            return (T)((Configuration)configurationFactory.build(file));
        }
        return (T)((Configuration)configurationFactory.build());
    }
}

