/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.yammer.dropwizard.util.Size;
import java.util.Set;
import javax.validation.constraints.NotNull;

public class GzipConfiguration {
    @JsonProperty
    private boolean enabled = true;
    @JsonProperty
    @NotNull
    private Size minimumEntitySize = Size.bytes(256L);
    @JsonProperty
    private Size bufferSize = Size.kilobytes(8L);
    @JsonProperty
    private ImmutableSet<String> excludedUserAgents = ImmutableSet.of();
    @JsonProperty
    private ImmutableSet<String> compressedMimeTypes = ImmutableSet.of();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Size getMinimumEntitySize() {
        return this.minimumEntitySize;
    }

    public void setMinimumEntitySize(Size size) {
        this.minimumEntitySize = (Size)Preconditions.checkNotNull((Object)size);
    }

    public Size getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Size size) {
        this.bufferSize = (Size)Preconditions.checkNotNull((Object)size);
    }

    public ImmutableSet<String> getExcludedUserAgents() {
        return this.excludedUserAgents;
    }

    public void setExcludedUserAgents(Set<String> userAgents) {
        this.excludedUserAgents = ImmutableSet.copyOf(userAgents);
    }

    public ImmutableSet<String> getCompressedMimeTypes() {
        return this.compressedMimeTypes;
    }

    public void setCompressedMimeTypes(Set<String> mimeTypes) {
        this.compressedMimeTypes = ImmutableSet.copyOf(mimeTypes);
    }
}

