/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.yammer.dropwizard.config.GzipConfiguration;
import com.yammer.dropwizard.config.RequestLogConfiguration;
import com.yammer.dropwizard.config.SslConfiguration;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.util.Size;
import com.yammer.dropwizard.validation.PortRange;
import com.yammer.dropwizard.validation.ValidationMethod;
import java.util.Locale;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class HttpConfiguration {
    @Valid
    @NotNull
    @JsonProperty
    private RequestLogConfiguration requestLog = new RequestLogConfiguration();
    @Valid
    @NotNull
    @JsonProperty
    private GzipConfiguration gzip = new GzipConfiguration();
    @Valid
    @JsonProperty
    private SslConfiguration ssl = null;
    @NotNull
    @JsonProperty
    private ImmutableMap<String, String> contextParameters = ImmutableMap.of();
    @PortRange
    @JsonProperty
    private int port = 8080;
    @PortRange
    @JsonProperty
    private int adminPort = 8081;
    @Min(value=2L)
    @Max(value=1000000L)
    @JsonProperty
    private int maxThreads = 1024;
    @Min(value=1L)
    @Max(value=1000000L)
    @JsonProperty
    private int minThreads = 8;
    @NotNull
    @JsonProperty
    private String rootPath = "/*";
    @NotNull
    @JsonProperty
    private ConnectorType connectorType = ConnectorType.BLOCKING;
    @NotNull
    @JsonProperty
    private Duration maxIdleTime = Duration.seconds(200L);
    @Min(value=1L)
    @Max(value=128L)
    @JsonProperty
    private int acceptorThreads = 1;
    @Min(value=-5L)
    @Max(value=5L)
    @JsonProperty
    private int acceptorThreadPriorityOffset = 0;
    @Min(value=-1L)
    @JsonProperty
    private int acceptQueueSize = -1;
    @Min(value=1L)
    @JsonProperty
    private int maxBufferCount = 1024;
    @NotNull
    @JsonProperty
    private Size requestBufferSize = Size.kilobytes(16L);
    @NotNull
    @JsonProperty
    private Size requestHeaderBufferSize = Size.kilobytes(6L);
    @NotNull
    @JsonProperty
    private Size responseBufferSize = Size.kilobytes(32L);
    @NotNull
    @JsonProperty
    private Size responseHeaderBufferSize = Size.kilobytes(6L);
    @JsonProperty
    private boolean reuseAddress = true;
    @JsonProperty
    private Duration soLingerTime = null;
    @JsonProperty
    private int lowResourcesConnectionThreshold = 0;
    @NotNull
    @JsonProperty
    private Duration lowResourcesMaxIdleTime = Duration.seconds(0L);
    @NotNull
    @JsonProperty
    private Duration shutdownGracePeriod = Duration.seconds(2L);
    @JsonProperty
    private boolean useServerHeader = false;
    @JsonProperty
    private boolean useDateHeader = true;
    @JsonProperty
    private boolean useForwardedHeaders = true;
    @JsonProperty
    private boolean useDirectBuffers = true;
    @JsonProperty
    private String bindHost = null;
    @JsonProperty
    private String adminUsername = null;
    @JsonProperty
    private String adminPassword = null;

    @ValidationMethod(message="must have an SSL configuration when using SSL connection")
    public boolean isSslConfigured() {
        ConnectorType type = this.getConnectorType();
        return this.ssl != null || type != ConnectorType.LEGACY_SSL && type != ConnectorType.NONBLOCKING_SSL;
    }

    @ValidationMethod(message="must have a smaller minThreads than maxThreads")
    public boolean isThreadPoolSizedCorrectly() {
        return this.minThreads <= this.maxThreads;
    }

    @ValidationMethod(message="must have adminUsername if adminPassword is defined")
    public boolean isAdminUsernameDefined() {
        return this.adminPassword == null || this.adminUsername != null;
    }

    public RequestLogConfiguration getRequestLogConfiguration() {
        return this.requestLog;
    }

    public void setRequestLogConfiguration(RequestLogConfiguration config) {
        this.requestLog = config;
    }

    public GzipConfiguration getGzipConfiguration() {
        return this.gzip;
    }

    public void setGzipConfiguration(GzipConfiguration config) {
        this.gzip = config;
    }

    public SslConfiguration getSslConfiguration() {
        return this.ssl;
    }

    public void setSslConfiguration(SslConfiguration config) {
        this.ssl = config;
    }

    public ImmutableMap<String, String> getContextParameters() {
        return this.contextParameters;
    }

    public void setContextParameters(Map<String, String> contextParameters) {
        this.contextParameters = ImmutableMap.copyOf(contextParameters);
    }

    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public void setConnectorType(ConnectorType type) {
        this.connectorType = type;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int port) {
        this.adminPort = port;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int count) {
        this.maxThreads = count;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    public void setMinThreads(int count) {
        this.minThreads = count;
    }

    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(Duration duration) {
        this.maxIdleTime = duration;
    }

    public int getAcceptorThreads() {
        return this.acceptorThreads;
    }

    public void setAcceptorThreads(int count) {
        this.acceptorThreads = count;
    }

    public int getAcceptorThreadPriorityOffset() {
        return this.acceptorThreadPriorityOffset;
    }

    public void setAcceptorThreadPriorityOffset(int priorityOffset) {
        this.acceptorThreadPriorityOffset = priorityOffset;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public void setAcceptQueueSize(int size) {
        this.acceptQueueSize = size;
    }

    public int getMaxBufferCount() {
        return this.maxBufferCount;
    }

    public void setMaxBufferCount(int count) {
        this.maxBufferCount = count;
    }

    public Size getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(Size size) {
        this.requestBufferSize = size;
    }

    public Size getRequestHeaderBufferSize() {
        return this.requestHeaderBufferSize;
    }

    public void setRequestHeaderBufferSize(Size size) {
        this.requestHeaderBufferSize = size;
    }

    public Size getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(Size size) {
        this.responseBufferSize = size;
    }

    public Size getResponseHeaderBufferSize() {
        return this.responseHeaderBufferSize;
    }

    public void setResponseHeaderBufferSize(Size size) {
        this.responseHeaderBufferSize = size;
    }

    public boolean isReuseAddressEnabled() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public Optional<Duration> getSoLingerTime() {
        return Optional.fromNullable((Object)this.soLingerTime);
    }

    public void setSoLingerTime(Duration duration) {
        this.soLingerTime = duration;
    }

    public int getLowResourcesConnectionThreshold() {
        return this.lowResourcesConnectionThreshold;
    }

    public void setLowResourcesConnectionThreshold(int connectionCount) {
        this.lowResourcesConnectionThreshold = connectionCount;
    }

    public Duration getLowResourcesMaxIdleTime() {
        return this.lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(Duration duration) {
        this.lowResourcesMaxIdleTime = duration;
    }

    public Duration getShutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public void setShutdownGracePeriod(Duration duration) {
        this.shutdownGracePeriod = duration;
    }

    public boolean useForwardedHeaders() {
        return this.useForwardedHeaders;
    }

    public void setUseForwardedHeaders(boolean useForwardedHeaders) {
        this.useForwardedHeaders = useForwardedHeaders;
    }

    public boolean useDirectBuffers() {
        return this.useDirectBuffers;
    }

    public void setUseDirectBuffers(boolean useDirectBuffers) {
        this.useDirectBuffers = useDirectBuffers;
    }

    public Optional<String> getBindHost() {
        return Optional.fromNullable((Object)this.bindHost);
    }

    public void setBindHost(String host) {
        this.bindHost = host;
    }

    public boolean isDateHeaderEnabled() {
        return this.useDateHeader;
    }

    public void setUseDateHeader(boolean useDateHeader) {
        this.useDateHeader = useDateHeader;
    }

    public boolean isServerHeaderEnabled() {
        return this.useServerHeader;
    }

    public void setUseServerHeader(boolean useServerHeader) {
        this.useServerHeader = useServerHeader;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String path) {
        this.rootPath = path;
    }

    public Optional<String> getAdminUsername() {
        return Optional.fromNullable((Object)this.adminUsername);
    }

    public void setAdminUsername(String username) {
        this.adminUsername = username;
    }

    public Optional<String> getAdminPassword() {
        return Optional.fromNullable((Object)this.adminPassword);
    }

    public void setAdminPassword(String password) {
        this.adminPassword = password;
    }

    public static enum ConnectorType {
        BLOCKING,
        LEGACY,
        LEGACY_SSL,
        NONBLOCKING,
        NONBLOCKING_SSL;


        @JsonValue
        public String toString() {
            return super.toString().replace("_", "+").toLowerCase(Locale.ENGLISH);
        }

        @JsonCreator
        public static ConnectorType parse(String type) {
            return ConnectorType.valueOf(type.toUpperCase(Locale.ENGLISH).replace('+', '_'));
        }
    }
}

