/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.yammer.dropwizard.config.ConfigurationException;
import com.yammer.dropwizard.config.Environment;
import com.yammer.dropwizard.config.GzipConfiguration;
import com.yammer.dropwizard.config.HttpConfiguration;
import com.yammer.dropwizard.config.RequestLogHandlerFactory;
import com.yammer.dropwizard.config.SslConfiguration;
import com.yammer.dropwizard.jersey.JacksonMessageBodyProvider;
import com.yammer.dropwizard.jetty.BiDiGzipHandler;
import com.yammer.dropwizard.jetty.UnbrandedErrorHandler;
import com.yammer.dropwizard.servlets.ThreadNameFilter;
import com.yammer.dropwizard.tasks.Task;
import com.yammer.dropwizard.tasks.TaskServlet;
import com.yammer.dropwizard.util.Duration;
import com.yammer.dropwizard.util.Size;
import com.yammer.metrics.HealthChecks;
import com.yammer.metrics.core.HealthCheck;
import com.yammer.metrics.jetty.InstrumentedBlockingChannelConnector;
import com.yammer.metrics.jetty.InstrumentedHandler;
import com.yammer.metrics.jetty.InstrumentedQueuedThreadPool;
import com.yammer.metrics.jetty.InstrumentedSelectChannelConnector;
import com.yammer.metrics.jetty.InstrumentedSocketConnector;
import com.yammer.metrics.jetty.InstrumentedSslSelectChannelConnector;
import com.yammer.metrics.jetty.InstrumentedSslSocketConnector;
import com.yammer.metrics.reporting.AdminServlet;
import com.yammer.metrics.util.DeadlockHealthCheck;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.AbstractNIOConnector;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerFactory.class);
    private final HttpConfiguration config;
    private final RequestLogHandlerFactory requestLogHandlerFactory;

    public ServerFactory(HttpConfiguration config, String name) {
        this.config = config;
        this.requestLogHandlerFactory = new RequestLogHandlerFactory(config.getRequestLogConfiguration(), name);
    }

    public Server buildServer(Environment env) throws ConfigurationException {
        HealthChecks.defaultRegistry().register((HealthCheck)new DeadlockHealthCheck());
        for (HealthCheck healthCheck : env.getHealthChecks()) {
            HealthChecks.defaultRegistry().register(healthCheck);
        }
        if (env.getHealthChecks().isEmpty()) {
            LOGGER.warn("\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!    THIS SERVICE HAS NO HEALTHCHECKS. THIS MEANS YOU WILL NEVER KNOW IF IT    !\n!    DIES IN PRODUCTION, WHICH MEANS YOU WILL NEVER KNOW IF YOU'RE LETTING     !\n!     YOUR USERS DOWN. YOU SHOULD ADD A HEALTHCHECK FOR EACH DEPENDENCY OF     !\n!     YOUR SERVICE WHICH FULLY (BUT LIGHTLY) TESTS YOUR SERVICE'S ABILITY TO   !\n!      USE THAT SERVICE. THINK OF IT AS A CONTINUOUS INTEGRATION TEST.         !\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        Server server = this.createServer();
        server.setHandler(this.createHandler(env));
        server.addBean((Object)env);
        return server;
    }

    private Server createServer() {
        Server server = new Server();
        server.addConnector(this.createExternalConnector());
        if (this.config.getAdminPort() == 0 || this.config.getAdminPort() != this.config.getPort()) {
            server.addConnector(this.createInternalConnector());
        }
        server.addBean((Object)new UnbrandedErrorHandler());
        server.setSendDateHeader(this.config.isDateHeaderEnabled());
        server.setSendServerVersion(this.config.isServerHeaderEnabled());
        server.setThreadPool(this.createThreadPool());
        server.setStopAtShutdown(true);
        server.setGracefulShutdown((int)this.config.getShutdownGracePeriod().toMilliseconds());
        return server;
    }

    private Connector createExternalConnector() {
        AbstractConnector connector = this.createConnector(this.config.getPort());
        connector.setHost((String)this.config.getBindHost().orNull());
        connector.setAcceptors(this.config.getAcceptorThreads());
        connector.setForwarded(this.config.useForwardedHeaders());
        connector.setMaxIdleTime((int)this.config.getMaxIdleTime().toMilliseconds());
        connector.setLowResourcesMaxIdleTime((int)this.config.getLowResourcesMaxIdleTime().toMilliseconds());
        connector.setAcceptorPriorityOffset(this.config.getAcceptorThreadPriorityOffset());
        connector.setAcceptQueueSize(this.config.getAcceptQueueSize());
        connector.setMaxBuffers(this.config.getMaxBufferCount());
        connector.setRequestBufferSize((int)this.config.getRequestBufferSize().toBytes());
        connector.setRequestHeaderSize((int)this.config.getRequestHeaderBufferSize().toBytes());
        connector.setResponseBufferSize((int)this.config.getResponseBufferSize().toBytes());
        connector.setResponseHeaderSize((int)this.config.getResponseHeaderBufferSize().toBytes());
        connector.setReuseAddress(this.config.isReuseAddressEnabled());
        Optional<Duration> lingerTime = this.config.getSoLingerTime();
        if (lingerTime.isPresent()) {
            connector.setSoLingerTime((int)((Duration)lingerTime.get()).toMilliseconds());
        }
        connector.setPort(this.config.getPort());
        connector.setName("main");
        return connector;
    }

    private AbstractConnector createConnector(int port) {
        InstrumentedBlockingChannelConnector connector;
        switch (this.config.getConnectorType()) {
            case BLOCKING: {
                connector = new InstrumentedBlockingChannelConnector(port);
                break;
            }
            case LEGACY: {
                connector = new InstrumentedSocketConnector(port);
                break;
            }
            case LEGACY_SSL: {
                connector = new InstrumentedSslSocketConnector(port);
                break;
            }
            case NONBLOCKING: {
                connector = new InstrumentedSelectChannelConnector(port);
                break;
            }
            case NONBLOCKING_SSL: {
                connector = new InstrumentedSslSelectChannelConnector(port);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid connector type: " + (Object)((Object)this.config.getConnectorType()));
            }
        }
        if (connector instanceof SslConnector) {
            this.configureSslContext(((SslConnector)connector).getSslContextFactory());
        }
        if (connector instanceof SelectChannelConnector) {
            ((SelectChannelConnector)connector).setLowResourcesConnections(this.config.getLowResourcesConnectionThreshold());
        }
        if (connector instanceof AbstractNIOConnector) {
            ((AbstractNIOConnector)connector).setUseDirectBuffers(this.config.useDirectBuffers());
        }
        return connector;
    }

    private void configureSslContext(SslContextFactory factory) {
        SslConfiguration sslConfig = this.config.getSslConfiguration();
        for (Object keyStore : sslConfig.getKeyStore().asSet()) {
            factory.setKeyStorePath(((File)keyStore).getAbsolutePath());
        }
        for (String password : sslConfig.getKeyStorePassword().asSet()) {
            factory.setKeyStorePassword(password);
        }
        for (String password : sslConfig.getKeyManagerPassword().asSet()) {
            factory.setKeyManagerPassword(password);
        }
        for (String certAlias : sslConfig.getCertAlias().asSet()) {
            factory.setCertAlias(certAlias);
        }
        String keyStoreType = sslConfig.getKeyStoreType();
        if (keyStoreType.startsWith("Windows-")) {
            try {
                Object keyStore;
                keyStore = KeyStore.getInstance(keyStoreType);
                ((KeyStore)keyStore).load(null, null);
                factory.setKeyStore((KeyStore)keyStore);
            }
            catch (Exception e) {
                throw new IllegalStateException("Windows key store not supported", e);
            }
        } else {
            factory.setKeyStoreType(keyStoreType);
        }
        for (File trustStore : sslConfig.getTrustStore().asSet()) {
            factory.setTrustStore(trustStore.getAbsolutePath());
        }
        for (String password : sslConfig.getTrustStorePassword().asSet()) {
            factory.setTrustStorePassword(password);
        }
        String trustStoreType = sslConfig.getTrustStoreType();
        if (trustStoreType.startsWith("Windows-")) {
            try {
                KeyStore keyStore = KeyStore.getInstance(trustStoreType);
                keyStore.load(null, null);
                factory.setTrustStore(keyStore);
            }
            catch (Exception e) {
                throw new IllegalStateException("Windows key store not supported", e);
            }
        } else {
            factory.setTrustStoreType(trustStoreType);
        }
        for (Boolean needClientAuth : sslConfig.getNeedClientAuth().asSet()) {
            factory.setNeedClientAuth(needClientAuth.booleanValue());
        }
        for (Boolean wantClientAuth : sslConfig.getWantClientAuth().asSet()) {
            factory.setWantClientAuth(wantClientAuth.booleanValue());
        }
        for (Boolean allowRenegotiate : sslConfig.getAllowRenegotiate().asSet()) {
            factory.setAllowRenegotiate(allowRenegotiate.booleanValue());
        }
        for (File crlPath : sslConfig.getCrlPath().asSet()) {
            factory.setCrlPath(crlPath.getAbsolutePath());
        }
        for (Boolean enable : sslConfig.getCrldpEnabled().asSet()) {
            factory.setEnableCRLDP(enable.booleanValue());
        }
        for (Boolean enable : sslConfig.getOcspEnabled().asSet()) {
            factory.setEnableOCSP(enable.booleanValue());
        }
        for (Integer length : sslConfig.getMaxCertPathLength().asSet()) {
            factory.setMaxCertPathLength(length.intValue());
        }
        for (URI uri : sslConfig.getOcspResponderUrl().asSet()) {
            factory.setOcspResponderURL(uri.toASCIIString());
        }
        for (String provider : sslConfig.getJceProvider().asSet()) {
            factory.setProvider(provider);
        }
        for (Boolean validate : sslConfig.getValidatePeers().asSet()) {
            factory.setValidatePeerCerts(validate.booleanValue());
        }
        factory.setIncludeProtocols((String[])Iterables.toArray(sslConfig.getSupportedProtocols(), String.class));
    }

    private Handler createHandler(Environment env) {
        HandlerCollection collection = new HandlerCollection();
        collection.addHandler(this.createInternalServlet(env));
        collection.addHandler(this.createExternalServlet(env));
        if (this.requestLogHandlerFactory.isEnabled()) {
            collection.addHandler((Handler)this.requestLogHandlerFactory.build());
        }
        return collection;
    }

    private Handler createInternalServlet(Environment env) {
        ServletContextHandler handler = new ServletContextHandler();
        handler.addServlet(new ServletHolder((Servlet)new TaskServlet((Iterable<Task>)env.getTasks())), "/tasks/*");
        handler.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/*");
        if (this.config.getAdminPort() != 0 && this.config.getAdminPort() == this.config.getPort()) {
            handler.setContextPath("/admin");
            handler.setConnectorNames(new String[]{"main"});
        } else {
            handler.setConnectorNames(new String[]{"internal"});
        }
        if (this.config.getAdminUsername().isPresent() || this.config.getAdminPassword().isPresent()) {
            handler.setSecurityHandler(this.basicAuthHandler((String)this.config.getAdminUsername().or((Object)""), (String)this.config.getAdminPassword().or((Object)"")));
        }
        return handler;
    }

    private SecurityHandler basicAuthHandler(String username, String password) {
        HashLoginService loginService = new HashLoginService();
        loginService.putUser(username, Credential.getCredential((String)password), new String[]{"user"});
        loginService.setName("admin");
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("admin");
        csh.addConstraintMapping(constraintMapping);
        csh.setLoginService((LoginService)loginService);
        return csh;
    }

    private Handler createExternalServlet(Environment env) {
        ServletContextHandler handler = new ServletContextHandler();
        handler.addFilter(ThreadNameFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        handler.setBaseResource(env.getBaseResource());
        if (!env.getProtectedTargets().isEmpty()) {
            handler.setProtectedTargets((String[])env.getProtectedTargets().toArray((Object[])new String[env.getProtectedTargets().size()]));
        }
        for (Map.Entry entry : env.getServlets().entrySet()) {
            handler.addServlet((ServletHolder)entry.getValue(), (String)entry.getKey());
        }
        ServletContainer jerseyContainer = env.getJerseyServletContainer();
        if (jerseyContainer != null) {
            env.addProvider((Object)new JacksonMessageBodyProvider(env.getObjectMapperFactory().build(), env.getValidator()));
            ServletHolder jerseyHolder = new ServletHolder((Servlet)jerseyContainer);
            jerseyHolder.setInitOrder(Integer.MAX_VALUE);
            handler.addServlet(jerseyHolder, this.config.getRootPath());
        }
        for (Map.Entry entry : env.getFilters().entries()) {
            handler.addFilter((FilterHolder)entry.getValue(), (String)entry.getKey(), EnumSet.of(DispatcherType.REQUEST));
        }
        for (EventListener listener : env.getServletListeners()) {
            handler.addEventListener(listener);
        }
        for (Map.Entry entry : this.config.getContextParameters().entrySet()) {
            handler.setInitParameter((String)entry.getKey(), (String)entry.getValue());
        }
        handler.setSessionHandler(env.getSessionHandler());
        handler.setConnectorNames(new String[]{"main"});
        return this.wrapHandler(handler);
    }

    private Handler wrapHandler(ServletContextHandler handler) {
        InstrumentedHandler instrumented = new InstrumentedHandler((Handler)handler);
        GzipConfiguration gzip = this.config.getGzipConfiguration();
        if (gzip.isEnabled()) {
            ImmutableSet<String> mimeTypes;
            BiDiGzipHandler gzipHandler = new BiDiGzipHandler((Handler)instrumented);
            Size minEntitySize = gzip.getMinimumEntitySize();
            gzipHandler.setMinGzipSize((int)minEntitySize.toBytes());
            Size bufferSize = gzip.getBufferSize();
            gzipHandler.setBufferSize((int)bufferSize.toBytes());
            ImmutableSet<String> userAgents = gzip.getExcludedUserAgents();
            if (!userAgents.isEmpty()) {
                gzipHandler.setExcluded((Set)userAgents);
            }
            if (!(mimeTypes = gzip.getCompressedMimeTypes()).isEmpty()) {
                gzipHandler.setMimeTypes((Set)mimeTypes);
            }
            return gzipHandler;
        }
        return instrumented;
    }

    private ThreadPool createThreadPool() {
        InstrumentedQueuedThreadPool pool = new InstrumentedQueuedThreadPool();
        pool.setMinThreads(this.config.getMinThreads());
        pool.setMaxThreads(this.config.getMaxThreads());
        return pool;
    }

    private Connector createInternalConnector() {
        SocketConnector connector = new SocketConnector();
        connector.setHost((String)this.config.getBindHost().orNull());
        connector.setPort(this.config.getAdminPort());
        connector.setName("internal");
        connector.setThreadPool((ThreadPool)new QueuedThreadPool(8));
        return connector;
    }
}

