/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;

public class SslConfiguration {
    @NotNull
    @JsonProperty
    private Optional<File> keyStore = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<String> keyStorePassword = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<String> keyManagerPassword = Optional.absent();
    @NotEmpty
    @JsonProperty
    private String keyStoreType = "JKS";
    @NotNull
    @JsonProperty
    private Optional<File> trustStore = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<String> trustStorePassword = Optional.absent();
    @NotEmpty
    @JsonProperty
    private String trustStoreType = "JKS";
    @NotNull
    @JsonProperty
    private Optional<Boolean> needClientAuth = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Boolean> wantClientAuth = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<String> certAlias = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Boolean> allowRenegotiate = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<File> crlPath = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Boolean> crldpEnabled = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Boolean> ocspEnabled = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Integer> maxCertPathLength = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<URI> ocspResponderUrl = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<String> jceProvider = Optional.absent();
    @NotNull
    @JsonProperty
    private Optional<Boolean> validatePeers = Optional.absent();
    @NotEmpty
    @JsonProperty
    private ImmutableList<String> supportedProtocols = ImmutableList.of((Object)"SSLv3", (Object)"TLSv1", (Object)"TLSv1.1", (Object)"TLSv1.2");

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = (String)Preconditions.checkNotNull((Object)keyStoreType);
    }

    public ImmutableList<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    public void setSupportedProtocols(List<String> protocols) {
        this.supportedProtocols = ImmutableList.copyOf(protocols);
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = (String)Preconditions.checkNotNull((Object)trustStoreType);
    }

    public Optional<File> getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(Optional<File> keyStore) {
        this.keyStore = keyStore;
    }

    public Optional<String> getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(Optional<String> keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public Optional<String> getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    public void setKeyManagerPassword(Optional<String> keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }

    public Optional<File> getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(Optional<File> trustStore) {
        this.trustStore = trustStore;
    }

    public Optional<String> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(Optional<String> trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public Optional<Boolean> getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(Optional<Boolean> needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public Optional<Boolean> getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(Optional<Boolean> wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public Optional<String> getCertAlias() {
        return this.certAlias;
    }

    public void setCertAlias(Optional<String> certAlias) {
        this.certAlias = certAlias;
    }

    public Optional<Boolean> getAllowRenegotiate() {
        return this.allowRenegotiate;
    }

    public void setAllowRenegotiate(Optional<Boolean> allowRenegotiate) {
        this.allowRenegotiate = allowRenegotiate;
    }

    public Optional<File> getCrlPath() {
        return this.crlPath;
    }

    public void setCrlPath(Optional<File> crlPath) {
        this.crlPath = crlPath;
    }

    public Optional<Boolean> getCrldpEnabled() {
        return this.crldpEnabled;
    }

    public void setCrldpEnabled(Optional<Boolean> crldpEnabled) {
        this.crldpEnabled = crldpEnabled;
    }

    public Optional<Boolean> getOcspEnabled() {
        return this.ocspEnabled;
    }

    public void setOcspEnabled(Optional<Boolean> ocspEnabled) {
        this.ocspEnabled = ocspEnabled;
    }

    public Optional<Integer> getMaxCertPathLength() {
        return this.maxCertPathLength;
    }

    public void setMaxCertPathLength(Optional<Integer> maxCertPathLength) {
        this.maxCertPathLength = maxCertPathLength;
    }

    public Optional<URI> getOcspResponderUrl() {
        return this.ocspResponderUrl;
    }

    public void setOcspResponderUrl(Optional<URI> ocspResponderUrl) {
        this.ocspResponderUrl = ocspResponderUrl;
    }

    public Optional<String> getJceProvider() {
        return this.jceProvider;
    }

    public void setJceProvider(Optional<String> jceProvider) {
        this.jceProvider = jceProvider;
    }

    public Optional<Boolean> getValidatePeers() {
        return this.validatePeers;
    }

    public void setValidatePeers(Optional<Boolean> validatePeers) {
        this.validatePeers = validatePeers;
    }
}

