/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;

public class AsyncAppender
extends AppenderBase<ILoggingEvent>
implements Runnable {
    private static final int BATCH_SIZE = 1000;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("async-log-appender-%d").setDaemon(true).build();
    private final Appender<ILoggingEvent> delegate;
    private final BlockingQueue<ILoggingEvent> queue;
    private final List<ILoggingEvent> batch;
    private final Thread dispatcher;
    private volatile boolean running;

    public static Appender<ILoggingEvent> wrap(Appender<ILoggingEvent> delegate) {
        AsyncAppender appender = new AsyncAppender(delegate);
        appender.start();
        return appender;
    }

    private AsyncAppender(Appender<ILoggingEvent> delegate) {
        this.delegate = delegate;
        this.queue = Queues.newLinkedBlockingQueue();
        this.batch = Lists.newArrayListWithCapacity((int)1000);
        this.dispatcher = THREAD_FACTORY.newThread(this);
        this.setContext(delegate.getContext());
    }

    protected void append(ILoggingEvent eventObject) {
        eventObject.prepareForDeferredProcessing();
        this.queue.add(eventObject);
    }

    public void start() {
        super.start();
        this.running = true;
        this.dispatcher.start();
    }

    public void stop() {
        this.running = false;
        super.stop();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.batch.add(this.queue.take());
                this.queue.drainTo(this.batch, 999);
                for (ILoggingEvent event : this.batch) {
                    this.delegate.doAppend((Object)event);
                }
                this.batch.clear();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

