/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.DefaultTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.spi.FilterAttachable;
import com.google.common.base.Optional;
import com.yammer.dropwizard.config.LoggingConfiguration;
import com.yammer.dropwizard.logging.LogFormatter;

public class LogbackFactory {
    private LogbackFactory() {
    }

    public static SyslogAppender buildSyslogAppender(LoggingConfiguration.SyslogConfiguration syslog, LoggerContext context, String name, Optional<String> logFormat) {
        SyslogAppender appender = new SyslogAppender();
        appender.setName(name);
        appender.setContext((Context)context);
        appender.setSyslogHost(syslog.getHost());
        appender.setFacility(syslog.getFacility().toString());
        LogbackFactory.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, syslog.getThreshold());
        for (String format : logFormat.asSet()) {
            appender.setSuffixPattern(format);
        }
        appender.start();
        return appender;
    }

    public static FileAppender<ILoggingEvent> buildFileAppender(LoggingConfiguration.FileConfiguration file, LoggerContext context, Optional<String> logFormat) {
        LogFormatter formatter = new LogFormatter(context, file.getTimeZone());
        for (String format : logFormat.asSet()) {
            formatter.setPattern(format);
        }
        formatter.start();
        RollingFileAppender appender = file.isArchive() ? new RollingFileAppender() : new FileAppender();
        appender.setAppend(true);
        appender.setContext((Context)context);
        appender.setLayout((Layout)formatter);
        appender.setFile(file.getCurrentLogFilename());
        appender.setPrudent(false);
        LogbackFactory.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, file.getThreshold());
        if (file.isArchive()) {
            DefaultTimeBasedFileNamingAndTriggeringPolicy triggeringPolicy = new DefaultTimeBasedFileNamingAndTriggeringPolicy();
            triggeringPolicy.setContext((Context)context);
            TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
            rollingPolicy.setContext((Context)context);
            rollingPolicy.setFileNamePattern(file.getArchivedLogFilenamePattern());
            rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
            triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
            rollingPolicy.setMaxHistory(file.getArchivedFileCount());
            appender.setRollingPolicy((RollingPolicy)rollingPolicy);
            appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            rollingPolicy.setParent((FileAppender)appender);
            rollingPolicy.start();
        }
        appender.stop();
        appender.start();
        return appender;
    }

    public static ConsoleAppender<ILoggingEvent> buildConsoleAppender(LoggingConfiguration.ConsoleConfiguration console, LoggerContext context, Optional<String> logFormat) {
        LogFormatter formatter = new LogFormatter(context, console.getTimeZone());
        for (String format : logFormat.asSet()) {
            formatter.setPattern(format);
        }
        formatter.start();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        appender.setLayout((Layout)formatter);
        LogbackFactory.addThresholdFilter((FilterAttachable<ILoggingEvent>)appender, console.getThreshold());
        appender.start();
        return appender;
    }

    private static void addThresholdFilter(FilterAttachable<ILoggingEvent> appender, Level threshold) {
        ThresholdFilter filter = new ThresholdFilter();
        filter.setLevel(threshold.toString());
        filter.start();
        appender.addFilter((Filter)filter);
    }
}

