/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.dropwizard.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class Duration {
    private static final Pattern PATTERN = Pattern.compile("[\\d]+[\\s]*(ns|nanosecond(s)?|us|microsecond(s)?|ms|millisecond(s)?|s|second(s)?|m|minute(s)?|h|hour(s)?|d|day(s)?)");
    private static final ImmutableMap<String, TimeUnit> SUFFIXES;
    private final long count;
    private final TimeUnit unit;

    public static Duration nanoseconds(long count) {
        return new Duration(count, TimeUnit.NANOSECONDS);
    }

    public static Duration microseconds(long count) {
        return new Duration(count, TimeUnit.MICROSECONDS);
    }

    public static Duration milliseconds(long count) {
        return new Duration(count, TimeUnit.MILLISECONDS);
    }

    public static Duration seconds(long count) {
        return new Duration(count, TimeUnit.SECONDS);
    }

    public static Duration minutes(long count) {
        return new Duration(count, TimeUnit.MINUTES);
    }

    public static Duration hours(long count) {
        return new Duration(count, TimeUnit.HOURS);
    }

    public static Duration days(long count) {
        return new Duration(count, TimeUnit.DAYS);
    }

    private static long parseCount(String s) {
        Preconditions.checkArgument((boolean)PATTERN.matcher(s).matches(), (String)"Invalid duration: %s", (Object[])new Object[]{s});
        String value = CharMatcher.WHITESPACE.removeFrom((CharSequence)s);
        return Long.parseLong(CharMatcher.JAVA_LETTER.trimTrailingFrom((CharSequence)value));
    }

    private static TimeUnit parseUnit(String s) {
        String value = CharMatcher.WHITESPACE.removeFrom((CharSequence)s);
        String suffix = CharMatcher.DIGIT.trimLeadingFrom((CharSequence)value);
        return (TimeUnit)((Object)SUFFIXES.get((Object)suffix));
    }

    @JsonCreator
    public static Duration parse(String duration) {
        return new Duration(Duration.parseCount(duration), Duration.parseUnit(duration));
    }

    private Duration(long count, TimeUnit unit) {
        this.count = count;
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit)));
    }

    public long getQuantity() {
        return this.count;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toNanoseconds() {
        return TimeUnit.NANOSECONDS.convert(this.count, this.unit);
    }

    public long toMicroseconds() {
        return TimeUnit.MICROSECONDS.convert(this.count, this.unit);
    }

    public long toMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.count, this.unit);
    }

    public long toSeconds() {
        return TimeUnit.SECONDS.convert(this.count, this.unit);
    }

    public long toMinutes() {
        return TimeUnit.MINUTES.convert(this.count, this.unit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.count, this.unit);
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.count, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Duration duration = (Duration)obj;
        return this.count == duration.count && this.unit == duration.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase();
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + ' ' + units;
    }

    static {
        ImmutableMap.Builder suffixes = ImmutableMap.builder();
        suffixes.put((Object)"ns", (Object)TimeUnit.NANOSECONDS);
        suffixes.put((Object)"nanosecond", (Object)TimeUnit.NANOSECONDS);
        suffixes.put((Object)"nanoseconds", (Object)TimeUnit.NANOSECONDS);
        suffixes.put((Object)"us", (Object)TimeUnit.MICROSECONDS);
        suffixes.put((Object)"microsecond", (Object)TimeUnit.MICROSECONDS);
        suffixes.put((Object)"microseconds", (Object)TimeUnit.MICROSECONDS);
        suffixes.put((Object)"ms", (Object)TimeUnit.MILLISECONDS);
        suffixes.put((Object)"millisecond", (Object)TimeUnit.MILLISECONDS);
        suffixes.put((Object)"milliseconds", (Object)TimeUnit.MILLISECONDS);
        suffixes.put((Object)"s", (Object)TimeUnit.SECONDS);
        suffixes.put((Object)"second", (Object)TimeUnit.SECONDS);
        suffixes.put((Object)"seconds", (Object)TimeUnit.SECONDS);
        suffixes.put((Object)"m", (Object)TimeUnit.MINUTES);
        suffixes.put((Object)"minute", (Object)TimeUnit.MINUTES);
        suffixes.put((Object)"minutes", (Object)TimeUnit.MINUTES);
        suffixes.put((Object)"h", (Object)TimeUnit.HOURS);
        suffixes.put((Object)"hour", (Object)TimeUnit.HOURS);
        suffixes.put((Object)"hours", (Object)TimeUnit.HOURS);
        suffixes.put((Object)"d", (Object)TimeUnit.DAYS);
        suffixes.put((Object)"day", (Object)TimeUnit.DAYS);
        suffixes.put((Object)"days", (Object)TimeUnit.DAYS);
        SUFFIXES = suffixes.build();
    }
}

