/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import de.codecentric.boot.admin.controller.RegistryController;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.registry.HashingApplicationUrlIdGenerator;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.registry.store.HazelcastApplicationStore;
import de.codecentric.boot.admin.registry.store.SimpleApplicationStore;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebappConfig
extends WebMvcConfigurerAdapter {
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
    }

    @Bean
    public RegistryController registryController(ApplicationRegistry registry) {
        return new RegistryController(registry);
    }

    @Bean
    public ApplicationRegistry applicationRegistry(ApplicationStore applicationStore, ApplicationIdGenerator applicationIdGenerator) {
        return new ApplicationRegistry(applicationStore, applicationIdGenerator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ApplicationIdGenerator applicationIdGenerator() {
        return new HashingApplicationUrlIdGenerator();
    }

    @Configuration
    @ConditionalOnClass(value={Hazelcast.class})
    @ConditionalOnExpression(value="${spring.boot.admin.hazelcast.enable:true}")
    @AutoConfigureBefore(value={SimpleConfig.class})
    public static class HazelcastConfig {
        @Value(value="${spring.boot.admin.hazelcast.map:spring-boot-admin-application-store}")
        private String hazelcastMapName;

        @Bean
        @ConditionalOnMissingBean
        public Config hazelcastConfig() {
            return new Config();
        }

        @Bean(destroyMethod="shutdown")
        @ConditionalOnMissingBean
        public HazelcastInstance hazelcastInstance(Config hazelcastConfig) {
            return Hazelcast.newHazelcastInstance((Config)hazelcastConfig);
        }

        @Bean
        @ConditionalOnMissingBean
        public ApplicationStore applicationStore(HazelcastInstance hazelcast) {
            IMap map = hazelcast.getMap(this.hazelcastMapName);
            map.addIndex("name", false);
            return new HazelcastApplicationStore((IMap<String, Application>)map);
        }
    }

    @Configuration
    public static class SimpleConfig {
        @Bean
        @ConditionalOnMissingBean
        public ApplicationStore applicationStore() {
            return new SimpleApplicationStore();
        }
    }
}

