/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.ApplicationRegistryConflictException;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistry.class);
    private final ApplicationStore store;
    private final ApplicationIdGenerator generator;

    public ApplicationRegistry(ApplicationStore store, ApplicationIdGenerator generator) {
        this.store = store;
        this.generator = generator;
    }

    public Application register(Application app) {
        Validate.notNull((Object)app, (String)"Application must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)app.getUrl(), (String)"URL must not be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.checkUrl(app.getUrl()), (String)"URL is not valid", (Object[])new Object[0]);
        String applicationId = this.generator.generateId(app);
        Validate.notNull((Object)applicationId, (String)"ID must not be null", (Object[])new Object[0]);
        Application newApp = new Application(app.getUrl(), app.getName(), applicationId);
        Application oldApp = this.store.save(newApp);
        if (oldApp == null) {
            LOGGER.info("New Application {} registered ", (Object)newApp);
        } else if (app.getUrl().equals(oldApp.getUrl()) && app.getName().equals(oldApp.getName())) {
            LOGGER.debug("Application {} refreshed", (Object)newApp);
        } else {
            LOGGER.warn("Application {} not registered because of conflict with {}", (Object)newApp, (Object)oldApp);
            throw new ApplicationRegistryConflictException(oldApp, app);
        }
        return newApp;
    }

    private boolean checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public Collection<Application> getApplications() {
        return this.store.findAll();
    }

    public Collection<Application> getApplicationsByName(String name) {
        return this.store.findByName(name);
    }

    public Application getApplication(String id) {
        return this.store.find(id);
    }

    public Application unregister(String id) {
        Application app = this.store.delete(id);
        LOGGER.info("Application {} unregistered ", (Object)app);
        return app;
    }
}

