/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;

public class HashingApplicationUrlIdGenerator
implements ApplicationIdGenerator {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public String generateId(Application a) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = digest.digest(a.getUrl().getBytes(StandardCharsets.UTF_8));
            return new String(this.encodeHex(bytes, 0, 8));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private char[] encodeHex(byte[] bytes, int offset, int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; i += 2) {
            byte b = bytes[offset + i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
        }
        return chars;
    }
}

