/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationRegisteredEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.model.StatusInfo;
import de.codecentric.boot.admin.registry.ApplicationIdGenerator;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationRegistry
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRegistry.class);
    private final ApplicationStore store;
    private final ApplicationIdGenerator generator;
    private ApplicationEventPublisher publisher;

    public ApplicationRegistry(ApplicationStore store, ApplicationIdGenerator generator) {
        this.store = store;
        this.generator = generator;
    }

    public Application register(Application application) {
        Assert.notNull((Object)application, (String)"Application must not be null");
        Assert.hasText((String)application.getName(), (String)"Name must not be null");
        Assert.hasText((String)application.getHealthUrl(), (String)"Health-URL must not be null");
        Assert.isTrue((boolean)this.checkUrl(application.getHealthUrl()), (String)"Health-URL is not valid");
        Assert.isTrue((StringUtils.isEmpty((Object)application.getManagementUrl()) || this.checkUrl(application.getManagementUrl()) ? 1 : 0) != 0, (String)"URL is not valid");
        Assert.isTrue((StringUtils.isEmpty((Object)application.getServiceUrl()) || this.checkUrl(application.getServiceUrl()) ? 1 : 0) != 0, (String)"URL is not valid");
        String applicationId = this.generator.generateId(application);
        Assert.notNull((Object)applicationId, (String)"ID must not be null");
        StatusInfo existingStatusInfo = this.getExistingStatusInfo(applicationId);
        Application registering = Application.create((Application)application).withId(applicationId).withStatusInfo(existingStatusInfo).build();
        Application replaced = this.store.save(registering);
        if (replaced == null) {
            LOGGER.info("New Application {} registered ", (Object)registering);
            this.publisher.publishEvent((Object)new ClientApplicationRegisteredEvent(registering));
        } else if (registering.getId().equals(replaced.getId())) {
            LOGGER.debug("Application {} refreshed", (Object)registering);
        } else {
            LOGGER.warn("Application {} replaced by Application {}", (Object)registering, (Object)replaced);
        }
        return registering;
    }

    private StatusInfo getExistingStatusInfo(String applicationId) {
        Application existing = this.getApplication(applicationId);
        if (existing != null) {
            return existing.getStatusInfo();
        }
        return StatusInfo.ofUnknown();
    }

    private boolean checkUrl(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public Collection<Application> getApplications() {
        return this.store.findAll();
    }

    public Collection<Application> getApplicationsByName(String name) {
        return this.store.findByName(name);
    }

    public Application getApplication(String id) {
        return this.store.find(id);
    }

    public Application deregister(String id) {
        Application app = this.store.delete(id);
        if (app != null) {
            LOGGER.info("Application {} unregistered ", (Object)app);
            this.publisher.publishEvent((Object)new ClientApplicationDeregisteredEvent(app));
        }
        return app;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }
}

