/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.AbstractEventNotifier;
import java.util.Arrays;

public abstract class AbstractStatusChangeNotifier
extends AbstractEventNotifier {
    private String[] ignoreChanges = new String[]{"UNKNOWN:UP"};

    @Override
    protected boolean shouldNotify(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationStatusChangedEvent) {
            ClientApplicationStatusChangedEvent statusChange = (ClientApplicationStatusChangedEvent)event;
            String from = statusChange.getFrom().getStatus();
            String to = statusChange.getTo().getStatus();
            return Arrays.binarySearch(this.ignoreChanges, from + ":" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, "*:" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, from + ":*") < 0;
        }
        return false;
    }

    public void setIgnoreChanges(String[] ignoreChanges) {
        Object[] copy = Arrays.copyOf(ignoreChanges, ignoreChanges.length);
        Arrays.sort(copy);
        this.ignoreChanges = copy;
    }

    public String[] getIgnoreChanges() {
        return this.ignoreChanges;
    }
}

