/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.model.Info;
import de.codecentric.boot.admin.model.StatusInfo;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import de.codecentric.boot.admin.web.client.ApplicationOperations;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.ResponseEntity;

public class StatusUpdater
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusUpdater.class);
    private final ApplicationStore store;
    private final ApplicationOperations applicationOps;
    private ApplicationEventPublisher publisher;
    private long statusLifetime = 10000L;

    public StatusUpdater(ApplicationStore store, ApplicationOperations applicationOps) {
        this.store = store;
        this.applicationOps = applicationOps;
    }

    public void updateStatusForAllApplications() {
        long now = System.currentTimeMillis();
        for (Application application : this.store.findAll()) {
            if (now - this.statusLifetime <= application.getStatusInfo().getTimestamp()) continue;
            this.updateStatus(application);
        }
    }

    public void updateStatus(Application application) {
        StatusInfo oldStatus = application.getStatusInfo();
        StatusInfo newStatus = this.queryStatus(application);
        boolean statusChanged = !newStatus.equals(oldStatus);
        Application.Builder builder = Application.copyOf(application).withStatusInfo(newStatus);
        if (statusChanged && !newStatus.isOffline() && !newStatus.isUnknown()) {
            builder.withInfo(this.queryInfo(application));
        }
        Application newState = builder.build();
        this.store.save(newState);
        if (statusChanged) {
            this.publisher.publishEvent((Object)new ClientApplicationStatusChangedEvent(newState, oldStatus, newStatus));
        }
    }

    protected Info queryInfo(Application application) {
        try {
            ResponseEntity<Map<String, Serializable>> response = this.applicationOps.getInfo(application);
            if (response.getStatusCode().is2xxSuccessful() && response.hasBody()) {
                return this.convertInfo(response);
            }
            LOGGER.info("Couldn't retrieve info for {}: {} - {}", new Object[]{application, response.getStatusCode(), response.getBody()});
            return Info.empty();
        }
        catch (Exception ex) {
            LOGGER.warn("Couldn't retrieve info for {}", (Object)application, (Object)ex);
            return this.convertInfo(ex);
        }
    }

    protected Info convertInfo(ResponseEntity<Map<String, Serializable>> response) {
        return Info.from((Map)response.getBody());
    }

    protected Info convertInfo(Exception ex) {
        return Info.empty();
    }

    protected StatusInfo queryStatus(Application application) {
        LOGGER.trace("Updating status for {}", (Object)application);
        try {
            return this.convertStatusInfo(this.applicationOps.getHealth(application));
        }
        catch (Exception ex) {
            if ("OFFLINE".equals(application.getStatusInfo().getStatus())) {
                LOGGER.debug("Couldn't retrieve status for {}", (Object)application, (Object)ex);
            } else {
                LOGGER.info("Couldn't retrieve status for {}", (Object)application, (Object)ex);
            }
            return this.convertStatusInfo(ex);
        }
    }

    protected StatusInfo convertStatusInfo(ResponseEntity<Map<String, Serializable>> response) {
        if (response.hasBody() && ((Map)response.getBody()).get("status") instanceof String) {
            return StatusInfo.valueOf((String)((Map)response.getBody()).get("status"), (Map)response.getBody());
        }
        if (response.getStatusCode().is2xxSuccessful()) {
            return StatusInfo.ofUp();
        }
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("status", response.getStatusCodeValue());
        details.put("error", response.getStatusCode().getReasonPhrase());
        if (response.hasBody()) {
            details.putAll((Map)response.getBody());
        }
        return StatusInfo.ofDown(details);
    }

    protected StatusInfo convertStatusInfo(Exception ex) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("message", ex.getMessage());
        details.put("exception", ex.getClass().getName());
        return StatusInfo.ofOffline(details);
    }

    public void setStatusLifetime(long statusLifetime) {
        this.statusLifetime = statusLifetime;
    }

    public long getStatusLifetime() {
        return this.statusLifetime;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

