/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.web.client;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.web.client.HttpHeadersProvider;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class BasicAuthHttpHeaderProvider
implements HttpHeadersProvider {
    @Override
    public HttpHeaders getHeaders(Application application) {
        String username = application.getMetadata().get("user.name");
        String password = application.getMetadata().get("user.password");
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            headers.set("Authorization", this.encode(username, password));
        }
        return headers;
    }

    protected String encode(String username, String password) {
        String token = Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return "Basic " + token;
    }
}

