/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.notify.NotificationTrigger;
import de.codecentric.boot.admin.server.notify.Notifier;
import java.util.concurrent.ConcurrentMap;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class HazelcastNotificationTrigger
extends NotificationTrigger {
    private static final Logger log = LoggerFactory.getLogger(HazelcastNotificationTrigger.class);
    private final ConcurrentMap<InstanceId, Long> sentNotifications;

    public HazelcastNotificationTrigger(Notifier notifier, Publisher<InstanceEvent> events, ConcurrentMap<InstanceId, Long> sentNotifications) {
        super(notifier, events);
        this.sentNotifications = sentNotifications;
    }

    @Override
    protected Mono<Void> sendNotifications(InstanceEvent event) {
        while (true) {
            Long lastSentEvent;
            if ((lastSentEvent = this.sentNotifications.getOrDefault(event.getInstance(), -1L)) >= event.getVersion()) {
                log.debug("Notifications already sent. Not triggering notifiers for {}", (Object)event);
                return Mono.empty();
            }
            if (lastSentEvent < 0L) {
                if (this.sentNotifications.putIfAbsent(event.getInstance(), event.getVersion()) != null) continue;
                log.debug("Triggering notifiers for {}", (Object)event);
                return super.sendNotifications(event);
            }
            if (this.sentNotifications.replace(event.getInstance(), lastSentEvent, event.getVersion())) break;
        }
        log.debug("Triggering notifiers for {}", (Object)event);
        return super.sendNotifications(event);
    }
}

