/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

public class BasicAuthHttpHeaderProvider
implements HttpHeadersProvider {
    private static final String[] USERNAME_KEYS = new String[]{"user.name", "user-name", "username"};
    private static final String[] PASSWORD_KEYS = new String[]{"user.password", "user-password", "userpassword"};
    @Nullable
    private final String defaultUserName;
    @Nullable
    private final String defaultPassword;
    private final Map<String, InstanceCredentials> serviceMap;

    public BasicAuthHttpHeaderProvider(@Nullable String defaultUserName, @Nullable String defaultPassword, Map<String, InstanceCredentials> serviceMap) {
        this.defaultUserName = defaultUserName;
        this.defaultPassword = defaultPassword;
        this.serviceMap = serviceMap;
    }

    public BasicAuthHttpHeaderProvider() {
        this(null, null, Collections.emptyMap());
    }

    @Override
    public HttpHeaders getHeaders(Instance instance) {
        String username = BasicAuthHttpHeaderProvider.getMetadataValue(instance, USERNAME_KEYS);
        String password = BasicAuthHttpHeaderProvider.getMetadataValue(instance, PASSWORD_KEYS);
        if (!StringUtils.hasText((String)username) || !StringUtils.hasText((String)password)) {
            String registeredName = instance.getRegistration().getName();
            InstanceCredentials credentials = this.serviceMap.get(registeredName);
            if (credentials != null) {
                username = credentials.getUserName();
                password = credentials.getUserPassword();
            } else {
                username = this.defaultUserName;
                password = this.defaultPassword;
            }
        }
        HttpHeaders headers = new HttpHeaders();
        if (StringUtils.hasText((String)username) && StringUtils.hasText((String)password)) {
            headers.set("Authorization", this.encode(username, password));
        }
        return headers;
    }

    protected String encode(String username, String password) {
        String token = Base64Utils.encodeToString((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        return "Basic " + token;
    }

    @Nullable
    private static String getMetadataValue(Instance instance, String[] keys) {
        Map<String, String> metadata = instance.getRegistration().getMetadata();
        for (String key : keys) {
            String value = metadata.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    public static class InstanceCredentials {
        @NonNull
        private String userName;
        @NonNull
        private String userPassword;

        @NonNull
        public String getUserName() {
            return this.userName;
        }

        @NonNull
        public String getUserPassword() {
            return this.userPassword;
        }

        public void setUserName(@NonNull String userName) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            this.userName = userName;
        }

        public void setUserPassword(@NonNull String userPassword) {
            if (userPassword == null) {
                throw new NullPointerException("userPassword is marked non-null but is null");
            }
            this.userPassword = userPassword;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstanceCredentials)) {
                return false;
            }
            InstanceCredentials other = (InstanceCredentials)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$userName = this.getUserName();
            String other$userName = other.getUserName();
            if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
                return false;
            }
            String this$userPassword = this.getUserPassword();
            String other$userPassword = other.getUserPassword();
            return !(this$userPassword == null ? other$userPassword != null : !this$userPassword.equals(other$userPassword));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InstanceCredentials;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $userName = this.getUserName();
            result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
            String $userPassword = this.getUserPassword();
            result = result * 59 + ($userPassword == null ? 43 : $userPassword.hashCode());
            return result;
        }

        public String toString() {
            return "BasicAuthHttpHeaderProvider.InstanceCredentials(userName=" + this.getUserName() + ", userPassword=" + this.getUserPassword() + ")";
        }

        public InstanceCredentials() {
        }

        public InstanceCredentials(@NonNull String userName, @NonNull String userPassword) {
            if (userName == null) {
                throw new NullPointerException("userName is marked non-null but is null");
            }
            if (userPassword == null) {
                throw new NullPointerException("userPassword is marked non-null but is null");
            }
            this.userName = userName;
            this.userPassword = userPassword;
        }
    }
}

