/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.maven.osgi.dp;

import com.google.common.io.ByteStreams;
import de.dentrassi.maven.osgi.dp.internal.ArtifactWalker;
import de.dentrassi.maven.osgi.dp.internal.ProjectWalker;
import de.dentrassi.maven.osgi.dp.internal.TychoWalker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.TychoProject;
import org.osgi.framework.Version;

public abstract class AbstractDpMojo
extends AbstractMojo {
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repositorySession;
    @Parameter(defaultValue="false")
    protected boolean useQualifiedFilename = false;
    @Parameter(defaultValue="false", property="osgi-dp.skip")
    protected boolean skip = false;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    private DependencyResolver dependencyResolver;
    private final Set<String> tychoWalkerProjects = new HashSet<String>(Arrays.asList("eclipse-feature"));
    @Component(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    @Parameter
    private Dependency[] additionalDependencies;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(property="version")
    private String version;

    protected ArtifactWalker lookupDependencyWalker() {
        String packaging = this.project.getPackaging();
        if (!this.tychoWalkerProjects.contains(packaging)) {
            return new ProjectWalker(this.project);
        }
        TychoProject facet = this.projectTypes.get(packaging);
        if (facet == null) {
            throw new IllegalStateException(String.format("Unknown packaging '%s'", packaging));
        }
        return new TychoWalker(facet.getDependencyWalker(this.project), this.getLog());
    }

    public void setVersion(String version) {
        this.version = Version.parseVersion((String)version).toString();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        String dpVersion = this.makeVersion(true);
        this.getLog().info((CharSequence)("Building DP - Version: " + dpVersion));
        Manifest dpmf = new Manifest();
        dpmf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1");
        dpmf.getMainAttributes().putValue("DeploymentPackage-SymbolicName", this.project.getArtifactId());
        dpmf.getMainAttributes().putValue("DeploymentPackage-Version", dpVersion);
        try {
            HashMap<String, File> files = new HashMap<String, File>();
            this.fillFromDependencies(dpmf, files);
            String dpName = String.format("%s_%s.dp", this.project.getArtifactId(), this.makeVersion(false));
            Path out = Paths.get(this.project.getBuild().getDirectory(), dpName);
            this.getLog().info((CharSequence)("Writing to: " + out));
            Files.createDirectories(out.getParent(), new FileAttribute[0]);
            try (JarOutputStream jar = new JarOutputStream(Files.newOutputStream(out, new OpenOption[0]), dpmf);){
                for (Map.Entry entry : files.entrySet()) {
                    Path p = ((File)entry.getValue()).toPath();
                    JarEntry je = new JarEntry((String)entry.getKey());
                    je.setSize(Files.size(p));
                    je.setLastModifiedTime(Files.getLastModifiedTime(p, new LinkOption[0]));
                    jar.putNextEntry(je);
                    InputStream in = Files.newInputStream(p, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        ByteStreams.copy((InputStream)in, (OutputStream)jar);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            this.attach(out);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to process", (Throwable)e);
        }
    }

    protected abstract void attach(Path var1);

    protected void fillFromDependencies(Manifest manifest, Map<String, File> files) throws IOException, MojoExecutionException {
        this.fillFromDependencyWalker(manifest, files);
        this.fillfromExtraDependencies(manifest, files);
    }

    protected void fillfromExtraDependencies(Manifest manifest, Map<String, File> files) throws IOException, MojoExecutionException {
        if (this.additionalDependencies != null) {
            try {
                ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>(this.additionalDependencies.length);
                for (Dependency dep : this.additionalDependencies) {
                    DefaultArtifact art = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getType(), dep.getVersion());
                    org.eclipse.aether.graph.Dependency adep = new org.eclipse.aether.graph.Dependency((Artifact)art, "runtime");
                    requests.add(new ArtifactRequest((DependencyNode)new DefaultDependencyNode(adep)));
                }
                List result = this.resolver.resolveArtifacts(this.repositorySession, requests);
                for (ArtifactResult ares : result) {
                    this.getLog().debug((CharSequence)("Additional dependency: " + ares));
                    this.processArtifact(manifest, files, ares.getArtifact().getFile());
                }
            }
            catch (ArtifactResolutionException e) {
                throw new MojoExecutionException("Failed to resolve additional dependencies", (Exception)((Object)e));
            }
        }
    }

    protected void fillFromDependencyWalker(Manifest manifest, Map<String, File> files) {
        ArtifactWalker dw = this.lookupDependencyWalker();
        dw.walk(entry -> this.processArtifact(manifest, files, entry.getLocation().toFile()));
    }

    protected void processArtifact(Manifest dpmf, Map<String, File> files, File location) throws IOException {
        try (JarFile jar = new JarFile(location);){
            Manifest mf = jar.getManifest();
            if (mf == null) {
                this.getLog().debug((CharSequence)"No Manifest");
                return;
            }
            String bsn = mf.getMainAttributes().getValue("Bundle-SymbolicName");
            if (bsn == null) {
                this.getLog().debug((CharSequence)"No BSN");
                return;
            }
            if (bsn != null) {
                bsn = bsn.split(";", 2)[0];
            }
            String version = mf.getMainAttributes().getValue("Bundle-Version");
            String fn = String.format("%s_%s.jar", bsn, version);
            Attributes attrs = new Attributes();
            attrs.putValue("Bundle-SymbolicName", bsn);
            attrs.putValue("Bundle-Version", version);
            dpmf.getEntries().put(fn, attrs);
            this.getLog().info((CharSequence)String.format("Added: %s:%s", bsn, version));
            files.put(fn, location);
        }
    }

    private String makeVersion(boolean osgiVersion) {
        if (this.version != null) {
            return this.version.toString();
        }
        if (this.useQualifiedFilename) {
            return this.makeQualifiedVersion().toString();
        }
        if (osgiVersion) {
            return this.makeQualifiedVersion().toString();
        }
        return this.project.getVersion();
    }

    private Version makeQualifiedVersion() {
        try {
            ReactorProject rp = (ReactorProject)this.project.getContextValue("tycho.reactor-project");
            if (rp != null) {
                return new Version(rp.getExpandedVersion());
            }
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"Failed to get qualified tycho version", (Throwable)e);
        }
        String version = this.project.getVersion();
        if (version.endsWith("-SNAPSHOT")) {
            version = version.replaceAll("-SNAPSHOT$", "." + TIMESTAMP_FORMAT.format(this.session.getStartTime()));
        }
        return new Version(version);
    }
}

