/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.maven.osgi.dp.internal;

import de.dentrassi.maven.osgi.dp.internal.ArtifactWalker;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.ArtifactDependencyWalker;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;

public class TychoWalker
implements ArtifactWalker {
    private final ArtifactDependencyWalker walker;
    private final Log logger;

    public TychoWalker(ArtifactDependencyWalker walker, Log logger) {
        this.walker = walker;
        this.logger = logger;
    }

    @Override
    public void walk(final ArtifactWalker.ArtifactConsumer consumer) {
        this.walker.walk(new ArtifactDependencyVisitor(){

            public boolean visitFeature(FeatureDescription feature) {
                return true;
            }

            public void visitPlugin(PluginDescription plugin) {
                try {
                    TychoWalker.this.logger.debug((CharSequence)String.format("Considering artifact: %s", plugin));
                    if (!"eclipse-plugin".equalsIgnoreCase(plugin.getKey().getType())) {
                        TychoWalker.this.logger.debug((CharSequence)String.format("Not a JAR file -> %s", plugin.getKey().getType()));
                        return;
                    }
                    ReactorProject p = plugin.getMavenProject();
                    File location = p != null ? p.getArtifact() : plugin.getLocation();
                    if (location == null) {
                        TychoWalker.this.logger.warn((CharSequence)String.format("Unable to locate artifact: %s", plugin));
                    }
                    if (!location.isFile()) {
                        TychoWalker.this.logger.warn((CharSequence)String.format("Location '%s' is not a file", location));
                        return;
                    }
                    consumer.accept(new ArtifactWalker.Entry(location.toPath()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

