/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.types.OsReleaseFile;
import de.flapdoodle.os.linux.OsReleaseFiles;
import java.util.List;

public enum CentosVersion implements Version
{
    CentOS_6(OsReleaseFiles.versionMatches(CentosVersion.centosReleaseFile(), "6")),
    CentOS_7(OsReleaseFiles.versionMatches(CentosVersion.centosReleaseFile(), "7")),
    CentOS_8(OsReleaseFiles.versionMatches(CentosVersion.centosReleaseFile(), "8"));

    public static final String RELEASE_FILE_NAME = "/etc/centos-release";
    private final List<Peculiarity<?>> peculiarities;

    private CentosVersion(Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList(peculiarities);
    }

    @Override
    public List<Peculiarity<?>> pecularities() {
        return this.peculiarities;
    }

    static Peculiarity<OsReleaseFile> centosReleaseFileNameMatches(String version) {
        return OsReleaseFiles.nameMatches(CentosVersion.centosReleaseFile(), version);
    }

    private static Attribute<OsReleaseFile> centosReleaseFile() {
        return OsReleaseFiles.releaseFile(RELEASE_FILE_NAME);
    }
}

