/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.utils.Guard;
import de.hilling.maven.release.versioning.GsonFactory;
import de.hilling.maven.release.versioning.ReleaseInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;

public class AnnotatedTag {
    private static final GsonFactory GSON_FACTORY = new GsonFactory();
    private final String name;
    private final ReleaseInfo releaseInfo;

    public AnnotatedTag(String name, ReleaseInfo releaseInfo) {
        Guard.notBlank("tag name", name);
        Guard.notNull("tag message", releaseInfo);
        this.name = name;
        this.releaseInfo = releaseInfo;
    }

    public Ref saveAtHEAD(Git git) throws GitAPIException {
        String message = GSON_FACTORY.createGson().toJson((Object)this.releaseInfo);
        return git.tag().setName(this.name).setAnnotated(true).setMessage(message).call();
    }

    public ReleaseInfo getReleaseInfo() {
        return this.releaseInfo;
    }

    public String name() {
        return this.name;
    }
}

