/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.NoChangesAction;
import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.repository.LocalGitRepo;
import de.hilling.maven.release.utils.ErrorUtils;
import de.hilling.maven.release.utils.GitHelper;
import de.hilling.maven.release.utils.JacocoLoader;
import de.hilling.maven.release.utils.SshAgentSessionFactory;
import java.util.List;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.SshSessionFactory;

public abstract class BaseMojo
extends AbstractMojo {
    private static final JacocoLoader JACOCO_LOADER = new JacocoLoader();
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    protected List<MavenProject> projects;
    @Parameter(alias="forceRelease", property="forceRelease")
    protected List<String> modulesToForceRelease;
    @Parameter(alias="noChangesAction", defaultValue="ReleaseAll", property="noChangesAction")
    protected NoChangesAction noChangesAction;
    @Parameter(defaultValue="false", alias="bugfixRelease", property="bugfixRelease")
    protected boolean bugfixRelease;
    @Parameter(property="disableSshAgent")
    private boolean disableSshAgent;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="knownHosts")
    private String knownHosts;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="passphrase")
    private String passphrase;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.configureJsch();
            Scm originalScm = this.project.getOriginalModel().getScm();
            Scm scm = this.project.getModel().getScm();
            LocalGitRepo repo = LocalGitRepo.fromCurrentDir(GitHelper.getRemoteUrlOrNullIfNoneSet(originalScm, scm), this.getLog());
            this.executeConcreteMojo(scm, originalScm, repo);
        }
        catch (ValidationException e) {
            ErrorUtils.printBigErrorMessageAndThrow(this.getLog(), e.getMessage(), e.getMessages());
        }
        catch (GitAPIException gae) {
            ErrorUtils.printBigGitErrorExceptionAndThrow(this.getLog(), gae);
        }
    }

    protected abstract void executeConcreteMojo(Scm var1, Scm var2, LocalGitRepo var3) throws MojoExecutionException, MojoFailureException, GitAPIException, ValidationException;

    final Settings getSettings() {
        return this.settings;
    }

    final void setSettings(Settings settings) {
        this.settings = settings;
    }

    final void setServerId(String serverId) {
        this.serverId = serverId;
    }

    final void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    final void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    final void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    final void disableSshAgent() {
        this.disableSshAgent = true;
    }

    protected final void configureJsch() {
        if (!this.disableSshAgent) {
            if (this.serverId != null) {
                Server server = this.settings.getServer(this.serverId);
                if (server != null) {
                    this.privateKey = this.privateKey == null ? server.getPrivateKey() : this.privateKey;
                    this.passphrase = this.passphrase == null ? server.getPassphrase() : this.passphrase;
                } else {
                    this.getLog().warn((CharSequence)String.format("No server configuration in Maven settings found with id %s", this.serverId));
                }
            }
            JschConfigSessionFactory.setInstance((SshSessionFactory)new SshAgentSessionFactory(this.getLog(), this.knownHosts, this.privateKey, this.passphrase));
        }
    }
}

