/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.BaseMojo;
import de.hilling.maven.release.repository.LocalGitRepo;
import de.hilling.maven.release.utils.ReleaseFileUtils;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="cleanup", requiresDirectInvocation=true, inheritByDefault=true, requiresProject=true, aggregator=true)
public class CleanupMojo
extends BaseMojo {
    private static File fromString(String fileName) {
        return new File(fileName);
    }

    @Override
    public void executeConcreteMojo(Scm scm, Scm originalScm, LocalGitRepo repo) throws MojoExecutionException, MojoFailureException, GitAPIException {
        List<File> filesToRevert = ReleaseFileUtils.read("files-to-revert.txt").stream().map(CleanupMojo::fromString).collect(Collectors.toList());
        if (!repo.revertChanges(this.getLog(), filesToRevert)) {
            String message = "Could not revert changes - working directory is no longer clean. Please revert changes manually";
            throw new MojoExecutionException(message);
        }
    }
}

