/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.ReleasableModule;
import de.hilling.maven.release.versioning.ImmutableModuleVersion;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.maven.project.MavenProject;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableReleasableModule
implements ReleasableModule {
    private final String relativePathToModule;
    private final MavenProject project;
    private final ImmutableModuleVersion immutableModule;
    private final boolean isToBeReleased;

    private ImmutableReleasableModule(String relativePathToModule, MavenProject project, ImmutableModuleVersion immutableModule, boolean isToBeReleased) {
        this.relativePathToModule = relativePathToModule;
        this.project = project;
        this.immutableModule = immutableModule;
        this.isToBeReleased = isToBeReleased;
    }

    @Override
    public String getRelativePathToModule() {
        return this.relativePathToModule;
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public ImmutableModuleVersion getImmutableModule() {
        return this.immutableModule;
    }

    @Override
    public boolean isToBeReleased() {
        return this.isToBeReleased;
    }

    public final ImmutableReleasableModule withRelativePathToModule(String value) {
        if (this.relativePathToModule.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "relativePathToModule");
        return new ImmutableReleasableModule(newValue, this.project, this.immutableModule, this.isToBeReleased);
    }

    public final ImmutableReleasableModule withProject(MavenProject value) {
        if (this.project == value) {
            return this;
        }
        MavenProject newValue = Objects.requireNonNull(value, "project");
        return new ImmutableReleasableModule(this.relativePathToModule, newValue, this.immutableModule, this.isToBeReleased);
    }

    public final ImmutableReleasableModule withImmutableModule(ImmutableModuleVersion value) {
        if (this.immutableModule == value) {
            return this;
        }
        ImmutableModuleVersion newValue = Objects.requireNonNull(value, "immutableModule");
        return new ImmutableReleasableModule(this.relativePathToModule, this.project, newValue, this.isToBeReleased);
    }

    public final ImmutableReleasableModule withIsToBeReleased(boolean value) {
        if (this.isToBeReleased == value) {
            return this;
        }
        return new ImmutableReleasableModule(this.relativePathToModule, this.project, this.immutableModule, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReleasableModule && this.equalTo((ImmutableReleasableModule)another);
    }

    private boolean equalTo(ImmutableReleasableModule another) {
        return this.relativePathToModule.equals(another.relativePathToModule) && this.project.equals((Object)another.project) && this.immutableModule.equals(another.immutableModule) && this.isToBeReleased == another.isToBeReleased;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.relativePathToModule.hashCode();
        h += (h << 5) + this.project.hashCode();
        h += (h << 5) + this.immutableModule.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isToBeReleased);
        return h;
    }

    public String toString() {
        return "ReleasableModule{relativePathToModule=" + this.relativePathToModule + ", project=" + this.project + ", immutableModule=" + this.immutableModule + ", isToBeReleased=" + this.isToBeReleased + "}";
    }

    public static ImmutableReleasableModule copyOf(ReleasableModule instance) {
        if (instance instanceof ImmutableReleasableModule) {
            return (ImmutableReleasableModule)instance;
        }
        return ImmutableReleasableModule.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RELATIVE_PATH_TO_MODULE = 1L;
        private static final long INIT_BIT_PROJECT = 2L;
        private static final long INIT_BIT_IMMUTABLE_MODULE = 4L;
        private static final long INIT_BIT_IS_TO_BE_RELEASED = 8L;
        private long initBits = 15L;
        @Nullable
        private String relativePathToModule;
        @Nullable
        private MavenProject project;
        @Nullable
        private ImmutableModuleVersion immutableModule;
        private boolean isToBeReleased;

        private Builder() {
        }

        public final Builder from(ReleasableModule instance) {
            Objects.requireNonNull(instance, "instance");
            this.relativePathToModule(instance.getRelativePathToModule());
            this.project(instance.getProject());
            this.immutableModule(instance.getImmutableModule());
            this.isToBeReleased(instance.isToBeReleased());
            return this;
        }

        public final Builder relativePathToModule(String relativePathToModule) {
            this.relativePathToModule = Objects.requireNonNull(relativePathToModule, "relativePathToModule");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder project(MavenProject project) {
            this.project = Objects.requireNonNull(project, "project");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder immutableModule(ImmutableModuleVersion immutableModule) {
            this.immutableModule = Objects.requireNonNull(immutableModule, "immutableModule");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder isToBeReleased(boolean isToBeReleased) {
            this.isToBeReleased = isToBeReleased;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableReleasableModule build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReleasableModule(this.relativePathToModule, this.project, this.immutableModule, this.isToBeReleased);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("relativePathToModule");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("project");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("immutableModule");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isToBeReleased");
            }
            return "Cannot build ReleasableModule, some of required attributes are not set " + attributes;
        }
    }
}

