/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.ImmutableReleasableModule;
import de.hilling.maven.release.ReleasableModule;
import de.hilling.maven.release.TreeWalkingDiffDetector;
import de.hilling.maven.release.repository.LocalGitRepo;
import de.hilling.maven.release.versioning.ImmutableFixVersion;
import de.hilling.maven.release.versioning.ImmutableModuleVersion;
import de.hilling.maven.release.versioning.ImmutableQualifiedArtifact;
import de.hilling.maven.release.versioning.ReleaseDateSingleton;
import de.hilling.maven.release.versioning.ReleaseInfo;
import de.hilling.maven.release.versioning.VersionNamer;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

class ModuleDependencyVerifier {
    private final ReleaseInfo previousRelease;
    private final LocalGitRepo gitRepo;
    private final Log log;
    private final MavenProject rootProject;
    private final List<String> modulesToForceRelease;
    private final List<ReleasableModule> modules;
    private final VersionNamer versionNamer;
    private final MavenProject project;

    public ModuleDependencyVerifier(MavenProject project, MavenProject rootProject, LocalGitRepo gitRepo, ReleaseInfo previousRelease, List<String> modulesToForceRelease, List<ReleasableModule> modules, boolean bugfixRelease, Log log) {
        this.gitRepo = gitRepo;
        this.log = log;
        this.rootProject = rootProject;
        this.modulesToForceRelease = modulesToForceRelease;
        this.modules = modules;
        this.previousRelease = previousRelease;
        this.versionNamer = new VersionNamer(bugfixRelease, previousRelease);
        this.project = project;
    }

    private static String calculateModulePath(MavenProject rootProject, MavenProject project) throws MojoExecutionException {
        File moduleRoot;
        File projectRoot;
        try {
            projectRoot = rootProject.getBasedir().getCanonicalFile();
            moduleRoot = project.getBasedir().getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not find directory paths for maven project", (Exception)e);
        }
        String relativePathToModule = Repository.stripWorkDir((File)projectRoot, (File)moduleRoot);
        if (relativePathToModule.length() == 0) {
            relativePathToModule = ".";
        }
        return relativePathToModule;
    }

    public ImmutableReleasableModule releaseInfo() throws MojoExecutionException {
        ImmutableFixVersion equivalentVersion;
        boolean toBeReleased;
        String relativePathToModule = ModuleDependencyVerifier.calculateModulePath(this.rootProject, this.project);
        String artifactId = this.project.getArtifactId();
        ImmutableFixVersion newVersion = ImmutableFixVersion.copyOf(this.versionNamer.nextVersion(this.project));
        boolean dependencyChanged = this.modules.stream().filter(ReleasableModule::isToBeReleased).anyMatch(this::dependencyOrParentChanged);
        Optional<ImmutableModuleVersion> previousVersion = this.previousRelease.getModules().stream().filter(m -> m.getArtifact().equals(this.artifact())).findAny();
        if (this.modulesToForceRelease.contains(artifactId)) {
            toBeReleased = true;
            equivalentVersion = newVersion;
            this.log.info((CharSequence)("Releasing " + artifactId + " " + newVersion.toString() + " as we was asked to forced release."));
        } else if (dependencyChanged) {
            toBeReleased = true;
            equivalentVersion = newVersion;
            this.log.info((CharSequence)("Releasing " + artifactId + " " + newVersion.toString() + " as at least one dependency has changed."));
        } else {
            Optional<String> tagInfo = previousVersion.map(ImmutableModuleVersion::getReleaseTag);
            if (tagInfo.isPresent()) {
                try {
                    String tagName = tagInfo.get();
                    this.log.info((CharSequence)("looking for tag with name '" + tagName + "'"));
                    Optional<Ref> tagRef = this.gitRepo.getRemoteTag(tagName);
                    if (tagRef.isPresent()) {
                        Ref gitTag = tagRef.get();
                        TreeWalkingDiffDetector detector = new TreeWalkingDiffDetector(this.gitRepo.git.getRepository(), this.log);
                        if (detector.hasChangedSince(relativePathToModule, this.moduleList(), gitTag)) {
                            toBeReleased = true;
                            equivalentVersion = newVersion;
                            this.log.info((CharSequence)("using " + equivalentVersion + " for " + artifactId + " as it has changed since the last release."));
                        }
                        toBeReleased = false;
                        equivalentVersion = previousVersion.get().getVersion();
                        this.log.info((CharSequence)("using " + equivalentVersion + " for " + artifactId + " as it has not been changed since that release."));
                    }
                    String message = "unable to find remote tag " + tagName;
                    this.log.error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
                catch (IOException | GitAPIException e) {
                    this.log.error((CharSequence)("unable to list tags: " + e.getMessage()));
                    throw new MojoExecutionException("unable to list tags", (Exception)e);
                }
            } else {
                toBeReleased = true;
                equivalentVersion = newVersion;
                this.log.info((CharSequence)("using " + equivalentVersion + " for " + artifactId + " as it has not been released yet."));
            }
        }
        ImmutableReleasableModule.Builder builder = ImmutableReleasableModule.builder();
        builder.project(this.project);
        builder.isToBeReleased(toBeReleased);
        builder.relativePathToModule(relativePathToModule);
        builder.immutableModule(this.moduleVersion(equivalentVersion, previousVersion, toBeReleased).build());
        return builder.build();
    }

    private ImmutableModuleVersion.Builder moduleVersion(ImmutableFixVersion equivalentVersion, Optional<ImmutableModuleVersion> previousVersion, boolean toBeReleased) {
        ImmutableModuleVersion.Builder moduleBuilder = ImmutableModuleVersion.builder();
        if (previousVersion.isPresent()) {
            moduleBuilder.from(previousVersion.get());
        } else {
            ImmutableQualifiedArtifact.Builder artifactBuilder = ImmutableQualifiedArtifact.builder();
            artifactBuilder.groupId(this.project.getGroupId()).artifactId(this.project.getArtifactId());
            moduleBuilder.artifact(artifactBuilder.build());
        }
        if (toBeReleased) {
            moduleBuilder.releaseTag(ReleaseDateSingleton.getInstance().tagName());
            moduleBuilder.releaseDate(ReleaseDateSingleton.getInstance().releaseDate());
        }
        moduleBuilder.version(equivalentVersion);
        return moduleBuilder;
    }

    public ReleasableModule rereleaseModule() throws MojoExecutionException {
        String relativePathToModule = ModuleDependencyVerifier.calculateModulePath(this.rootProject, this.project);
        String artifactId = this.project.getArtifactId();
        ImmutableFixVersion newVersion = ImmutableFixVersion.copyOf(this.versionNamer.nextVersion(this.project));
        this.log.info((CharSequence)("using " + newVersion + " for " + artifactId + " for rerelease."));
        ImmutableReleasableModule.Builder builder = ImmutableReleasableModule.builder();
        builder.project(this.project);
        builder.immutableModule(this.moduleVersion(newVersion, Optional.empty(), true).build());
        builder.isToBeReleased(true);
        builder.relativePathToModule(relativePathToModule);
        return builder.build();
    }

    private List<String> moduleList() {
        return this.project.getModules();
    }

    private ImmutableQualifiedArtifact artifact() {
        return ImmutableQualifiedArtifact.builder().groupId(this.project.getGroupId()).artifactId(this.project.getArtifactId()).build();
    }

    private boolean dependencyOrParentChanged(ReleasableModule module) {
        for (Dependency dependency : this.project.getModel().getDependencies()) {
            if (!this.moduleIsADependency(module, dependency)) continue;
            return true;
        }
        return this.isThisProjectsParentModule(module);
    }

    private boolean moduleIsADependency(ReleasableModule module, Dependency dependency) {
        return dependency.getGroupId().equals(module.getProject().getGroupId()) && dependency.getArtifactId().equals(module.getProject().getArtifactId());
    }

    private boolean isThisProjectsParentModule(ReleasableModule module) {
        MavenProject parent = this.project.getParent();
        MavenProject moduleProject = module.getProject();
        return parent != null && parent.getGroupId().equals(moduleProject.getGroupId()) && parent.getArtifactId().equals(moduleProject.getArtifactId());
    }
}

