/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.Reactor;
import de.hilling.maven.release.ReleasableModule;
import de.hilling.maven.release.exceptions.UnresolvedSnapshotDependencyException;
import de.hilling.maven.release.versioning.ImmutableFixVersion;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public class PomUpdater {
    private final Log log;
    private final Reactor reactor;

    public PomUpdater(Log log, Reactor reactor) {
        this.log = log;
        this.reactor = reactor;
    }

    private static boolean isMultiModuleReleasePlugin(Plugin plugin) {
        return plugin.getGroupId().equals("de.hilling.maven.release") && plugin.getArtifactId().equals("smart-release-plugin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateResult updateVersion() {
        ArrayList<File> changedPoms = new ArrayList<File>();
        ArrayList<String> errors = new ArrayList<String>();
        List modulesToRelease = this.reactor.getModulesInBuildOrder().stream().filter(ReleasableModule::isToBeReleased).collect(Collectors.toList());
        for (ReleasableModule module : modulesToRelease) {
            try {
                MavenProject project = module.getProject();
                ImmutableFixVersion version = module.getImmutableModule().getVersion();
                this.log.info((CharSequence)("Going to release " + module.getProject().getArtifactId() + " " + version.toString()));
                List<String> errorsForCurrentPom = this.alterModel(project, version.toString());
                errors.addAll(errorsForCurrentPom);
                File pom = project.getFile().getCanonicalFile();
                changedPoms.add(pom);
                Model originalModel = project.getOriginalModel();
                try (XmlStreamWriter fileWriter = WriterFactory.newXmlWriter((File)pom);){
                    MavenXpp3Writer pomWriter = new MavenXpp3Writer();
                    pomWriter.write((Writer)fileWriter, originalModel);
                }
            }
            catch (Exception e) {
                return new UpdateResult(changedPoms, errors, e);
            }
        }
        return new UpdateResult(changedPoms, errors, null);
    }

    private List<String> alterModel(MavenProject project, String newVersion) {
        String version;
        Model originalModel = project.getOriginalModel();
        originalModel.setVersion(newVersion);
        ArrayList<String> errors = new ArrayList<String>();
        String searchingFrom = project.getArtifactId();
        MavenProject parent = project.getParent();
        if (parent != null && this.isSnapshot(parent.getVersion())) {
            try {
                ReleasableModule parentBeingReleased = this.reactor.find(parent.getGroupId(), parent.getArtifactId());
                ImmutableFixVersion version2 = parentBeingReleased.getImmutableModule().getVersion();
                originalModel.getParent().setVersion(version2.toString());
                this.log.debug((CharSequence)(" Parent " + parentBeingReleased.getProject().getArtifactId() + " rewritten to version " + version2.toString()));
            }
            catch (UnresolvedSnapshotDependencyException e) {
                errors.add("The parent of " + searchingFrom + " is " + e.artifactId);
            }
        }
        Properties projectProperties = project.getProperties();
        for (Dependency dependency : originalModel.getDependencies()) {
            version = dependency.getVersion();
            if (this.isSnapshot(this.resolveVersion(version, projectProperties))) {
                try {
                    ReleasableModule dependencyBeingReleased = this.reactor.find(dependency.getGroupId(), dependency.getArtifactId());
                    ImmutableFixVersion dependencyVersion = dependencyBeingReleased.getImmutableModule().getVersion();
                    dependency.setVersion(dependencyVersion.toString());
                    this.log.debug((CharSequence)(" Dependency on " + dependencyBeingReleased.getProject().getArtifactId() + " rewritten to version " + dependencyVersion.toString()));
                }
                catch (UnresolvedSnapshotDependencyException e) {
                    errors.add(searchingFrom + " references dependency " + e.artifactId);
                }
                continue;
            }
            this.log.debug((CharSequence)(" Dependency on " + dependency.getArtifactId() + " kept at version " + dependency.getVersion()));
        }
        for (Plugin plugin : project.getModel().getBuild().getPlugins()) {
            version = plugin.getVersion();
            if (!this.isSnapshot(this.resolveVersion(version, projectProperties)) || PomUpdater.isMultiModuleReleasePlugin(plugin)) continue;
            errors.add(searchingFrom + " references plugin " + plugin.getArtifactId() + " " + version);
        }
        return errors;
    }

    private String resolveVersion(String version, Properties projectProperties) {
        if (version != null && version.startsWith("${")) {
            return projectProperties.getProperty(version.replace("${", "").replace("}", ""), version);
        }
        return version;
    }

    private boolean isSnapshot(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }

    public static class UpdateResult {
        public final List<File> alteredPoms;
        public final List<String> dependencyErrors;
        public final Exception unexpectedException;

        public UpdateResult(List<File> alteredPoms, List<String> dependencyErrors, Exception unexpectedException) {
            this.alteredPoms = alteredPoms;
            this.dependencyErrors = dependencyErrors;
            this.unexpectedException = unexpectedException;
        }

        public boolean success() {
            return this.dependencyErrors.size() == 0 && this.unexpectedException == null;
        }
    }
}

