/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.errors.GitAPIException;

public final class ErrorUtils {
    private ErrorUtils() {
    }

    public static void printBigErrorMessageAndThrow(Log log, String terseMessage, List<String> linesToLog) throws MojoExecutionException {
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"Could not execute the release plugin");
        log.error((CharSequence)"************************************");
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        for (String line : linesToLog) {
            log.error((CharSequence)line);
        }
        log.error((CharSequence)"");
        log.error((CharSequence)"");
        throw new MojoExecutionException(terseMessage);
    }

    public static void printBigGitErrorExceptionAndThrow(Log log, GitAPIException gae) throws MojoExecutionException {
        StringWriter sw = new StringWriter();
        gae.printStackTrace(new PrintWriter(sw));
        String exceptionAsString = sw.toString();
        ErrorUtils.printBigErrorMessageAndThrow(log, "Could not release due to a Git error", Arrays.asList("There was an error while accessing the Git repository. The error returned from git was:", gae.getMessage(), "Stack trace:", exceptionAsString));
    }
}

