/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.utils;

import de.hilling.maven.release.exceptions.ValidationException;
import java.util.Arrays;
import org.apache.maven.model.Scm;

public class GitHelper {
    public static final String NEED_TO_USE_GIT = "Cannot run the release plugin with a non-Git version control system";
    public static final String GIT_PREFIX = "scm:git:";

    public static String scmUrlToRemote(String scmUrl) throws ValidationException {
        if (!scmUrl.startsWith(GIT_PREFIX)) {
            throw new ValidationException(NEED_TO_USE_GIT, Arrays.asList(NEED_TO_USE_GIT, "The value in your scm tag is " + scmUrl));
        }
        String remote = scmUrl.substring(GIT_PREFIX.length());
        remote = remote.replace("file://localhost/", "file:///");
        return remote;
    }

    public static String getRemoteUrlOrNullIfNoneSet(Scm originalScm, Scm actualScm) throws ValidationException {
        if (originalScm == null) {
            return null;
        }
        String remote = actualScm.getDeveloperConnection();
        if (remote == null) {
            remote = actualScm.getConnection();
        }
        if (remote == null) {
            return null;
        }
        return GitHelper.scmUrlToRemote(remote);
    }
}

