/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.ImmutableFixVersion;
import de.hilling.maven.release.versioning.ImmutableQualifiedArtifact;
import de.hilling.maven.release.versioning.ModuleVersion;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableModuleVersion
extends ModuleVersion {
    private final ZonedDateTime releaseDate;
    private final String releaseTag;
    private final ImmutableQualifiedArtifact artifact;
    private final ImmutableFixVersion version;

    private ImmutableModuleVersion(ZonedDateTime releaseDate, String releaseTag, ImmutableQualifiedArtifact artifact, ImmutableFixVersion version) {
        this.releaseDate = releaseDate;
        this.releaseTag = releaseTag;
        this.artifact = artifact;
        this.version = version;
    }

    @Override
    public ZonedDateTime getReleaseDate() {
        return this.releaseDate;
    }

    @Override
    public String getReleaseTag() {
        return this.releaseTag;
    }

    @Override
    public ImmutableQualifiedArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public ImmutableFixVersion getVersion() {
        return this.version;
    }

    public final ImmutableModuleVersion withReleaseDate(ZonedDateTime value) {
        if (this.releaseDate == value) {
            return this;
        }
        ZonedDateTime newValue = Objects.requireNonNull(value, "releaseDate");
        return new ImmutableModuleVersion(newValue, this.releaseTag, this.artifact, this.version);
    }

    public final ImmutableModuleVersion withReleaseTag(String value) {
        if (this.releaseTag.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "releaseTag");
        return new ImmutableModuleVersion(this.releaseDate, newValue, this.artifact, this.version);
    }

    public final ImmutableModuleVersion withArtifact(ImmutableQualifiedArtifact value) {
        if (this.artifact == value) {
            return this;
        }
        ImmutableQualifiedArtifact newValue = Objects.requireNonNull(value, "artifact");
        return new ImmutableModuleVersion(this.releaseDate, this.releaseTag, newValue, this.version);
    }

    public final ImmutableModuleVersion withVersion(ImmutableFixVersion value) {
        if (this.version == value) {
            return this;
        }
        ImmutableFixVersion newValue = Objects.requireNonNull(value, "version");
        return new ImmutableModuleVersion(this.releaseDate, this.releaseTag, this.artifact, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModuleVersion && this.equalTo((ImmutableModuleVersion)another);
    }

    private boolean equalTo(ImmutableModuleVersion another) {
        return this.releaseDate.equals(another.releaseDate) && this.releaseTag.equals(another.releaseTag) && this.artifact.equals(another.artifact) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.releaseDate.hashCode();
        h += (h << 5) + this.releaseTag.hashCode();
        h += (h << 5) + this.artifact.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public static ImmutableModuleVersion copyOf(ModuleVersion instance) {
        if (instance instanceof ImmutableModuleVersion) {
            return (ImmutableModuleVersion)instance;
        }
        return ImmutableModuleVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RELEASE_DATE = 1L;
        private static final long INIT_BIT_RELEASE_TAG = 2L;
        private static final long INIT_BIT_ARTIFACT = 4L;
        private static final long INIT_BIT_VERSION = 8L;
        private long initBits = 15L;
        @Nullable
        private ZonedDateTime releaseDate;
        @Nullable
        private String releaseTag;
        @Nullable
        private ImmutableQualifiedArtifact artifact;
        @Nullable
        private ImmutableFixVersion version;

        private Builder() {
        }

        public final Builder from(ModuleVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.releaseDate(instance.getReleaseDate());
            this.releaseTag(instance.getReleaseTag());
            this.artifact(instance.getArtifact());
            this.version(instance.getVersion());
            return this;
        }

        public final Builder releaseDate(ZonedDateTime releaseDate) {
            this.releaseDate = Objects.requireNonNull(releaseDate, "releaseDate");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder releaseTag(String releaseTag) {
            this.releaseTag = Objects.requireNonNull(releaseTag, "releaseTag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder artifact(ImmutableQualifiedArtifact artifact) {
            this.artifact = Objects.requireNonNull(artifact, "artifact");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder version(ImmutableFixVersion version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableModuleVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModuleVersion(this.releaseDate, this.releaseTag, this.artifact, this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("releaseDate");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("releaseTag");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("artifact");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build ModuleVersion, some of required attributes are not set " + attributes;
        }
    }
}

