/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.QualifiedArtifact;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableQualifiedArtifact
extends QualifiedArtifact {
    private final String groupId;
    private final String artifactId;

    private ImmutableQualifiedArtifact(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    public final ImmutableQualifiedArtifact withGroupId(String value) {
        if (this.groupId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "groupId");
        return new ImmutableQualifiedArtifact(newValue, this.artifactId);
    }

    public final ImmutableQualifiedArtifact withArtifactId(String value) {
        if (this.artifactId.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "artifactId");
        return new ImmutableQualifiedArtifact(this.groupId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQualifiedArtifact && this.equalTo((ImmutableQualifiedArtifact)another);
    }

    private boolean equalTo(ImmutableQualifiedArtifact another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        return h;
    }

    public static ImmutableQualifiedArtifact copyOf(QualifiedArtifact instance) {
        if (instance instanceof ImmutableQualifiedArtifact) {
            return (ImmutableQualifiedArtifact)instance;
        }
        return ImmutableQualifiedArtifact.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String groupId;
        @Nullable
        private String artifactId;

        private Builder() {
        }

        public final Builder from(QualifiedArtifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.groupId(instance.getGroupId());
            this.artifactId(instance.getArtifactId());
            return this;
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQualifiedArtifact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQualifiedArtifact(this.groupId, this.artifactId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build QualifiedArtifact, some of required attributes are not set " + attributes;
        }
    }
}

